/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.models;

import com.microsoft.graph.models.AuthenticationMethod;
import com.microsoft.graph.models.AuthenticationMethodSignInState;
import com.microsoft.graph.models.AuthenticationPhoneType;
import com.microsoft.kiota.serialization.Parsable;
import com.microsoft.kiota.serialization.ParseNode;
import com.microsoft.kiota.serialization.SerializationWriter;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;

public class PhoneAuthenticationMethod
extends AuthenticationMethod
implements Parsable {
    public PhoneAuthenticationMethod() {
        this.setOdataType("#microsoft.graph.phoneAuthenticationMethod");
    }

    @Nonnull
    public static PhoneAuthenticationMethod createFromDiscriminatorValue(@Nonnull ParseNode parseNode) {
        Objects.requireNonNull(parseNode);
        return new PhoneAuthenticationMethod();
    }

    @Override
    @Nonnull
    public Map<String, Consumer<ParseNode>> getFieldDeserializers() {
        HashMap<String, Consumer<ParseNode>> deserializerMap = new HashMap<String, Consumer<ParseNode>>(super.getFieldDeserializers());
        deserializerMap.put("phoneNumber", n -> this.setPhoneNumber(n.getStringValue()));
        deserializerMap.put("phoneType", n -> this.setPhoneType((AuthenticationPhoneType)n.getEnumValue(AuthenticationPhoneType::forValue)));
        deserializerMap.put("smsSignInState", n -> this.setSmsSignInState((AuthenticationMethodSignInState)n.getEnumValue(AuthenticationMethodSignInState::forValue)));
        return deserializerMap;
    }

    @Nullable
    public String getPhoneNumber() {
        return (String)this.backingStore.get("phoneNumber");
    }

    @Nullable
    public AuthenticationPhoneType getPhoneType() {
        return (AuthenticationPhoneType)((Object)this.backingStore.get("phoneType"));
    }

    @Nullable
    public AuthenticationMethodSignInState getSmsSignInState() {
        return (AuthenticationMethodSignInState)((Object)this.backingStore.get("smsSignInState"));
    }

    @Override
    public void serialize(@Nonnull SerializationWriter writer) {
        Objects.requireNonNull(writer);
        super.serialize(writer);
        writer.writeStringValue("phoneNumber", this.getPhoneNumber());
        writer.writeEnumValue("phoneType", (Enum)this.getPhoneType());
        writer.writeEnumValue("smsSignInState", (Enum)this.getSmsSignInState());
    }

    public void setPhoneNumber(@Nullable String value) {
        this.backingStore.set("phoneNumber", (Object)value);
    }

    public void setPhoneType(@Nullable AuthenticationPhoneType value) {
        this.backingStore.set("phoneType", (Object)value);
    }

    public void setSmsSignInState(@Nullable AuthenticationMethodSignInState value) {
        this.backingStore.set("smsSignInState", (Object)value);
    }
}

