/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.models;

import com.microsoft.graph.models.EngagementConversation;
import com.microsoft.graph.models.EngagementConversationDiscussionMessage;
import com.microsoft.graph.models.EngagementConversationMessageReaction;
import com.microsoft.graph.models.EngagementConversationQuestionMessage;
import com.microsoft.graph.models.EngagementConversationSystemMessage;
import com.microsoft.graph.models.EngagementCreationMode;
import com.microsoft.graph.models.EngagementIdentitySet;
import com.microsoft.graph.models.Entity;
import com.microsoft.graph.models.ItemBody;
import com.microsoft.kiota.serialization.Parsable;
import com.microsoft.kiota.serialization.ParseNode;
import com.microsoft.kiota.serialization.SerializationWriter;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.time.OffsetDateTime;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;

public class EngagementConversationMessage
extends Entity
implements Parsable {
    @Nonnull
    public static EngagementConversationMessage createFromDiscriminatorValue(@Nonnull ParseNode parseNode) {
        Objects.requireNonNull(parseNode);
        ParseNode mappingValueNode = parseNode.getChildNode("@odata.type");
        if (mappingValueNode != null) {
            String mappingValue;
            switch (mappingValue = mappingValueNode.getStringValue()) {
                case "#microsoft.graph.engagementConversationDiscussionMessage": {
                    return new EngagementConversationDiscussionMessage();
                }
                case "#microsoft.graph.engagementConversationQuestionMessage": {
                    return new EngagementConversationQuestionMessage();
                }
                case "#microsoft.graph.engagementConversationSystemMessage": {
                    return new EngagementConversationSystemMessage();
                }
            }
        }
        return new EngagementConversationMessage();
    }

    @Nullable
    public ItemBody getBody() {
        return (ItemBody)this.backingStore.get("body");
    }

    @Nullable
    public EngagementConversation getConversation() {
        return (EngagementConversation)this.backingStore.get("conversation");
    }

    @Nullable
    public OffsetDateTime getCreatedDateTime() {
        return (OffsetDateTime)this.backingStore.get("createdDateTime");
    }

    @Nullable
    public EngagementCreationMode getCreationMode() {
        return (EngagementCreationMode)((Object)this.backingStore.get("creationMode"));
    }

    @Override
    @Nonnull
    public Map<String, Consumer<ParseNode>> getFieldDeserializers() {
        HashMap<String, Consumer<ParseNode>> deserializerMap = new HashMap<String, Consumer<ParseNode>>(super.getFieldDeserializers());
        deserializerMap.put("body", n -> this.setBody((ItemBody)n.getObjectValue(ItemBody::createFromDiscriminatorValue)));
        deserializerMap.put("conversation", n -> this.setConversation((EngagementConversation)n.getObjectValue(EngagementConversation::createFromDiscriminatorValue)));
        deserializerMap.put("createdDateTime", n -> this.setCreatedDateTime(n.getOffsetDateTimeValue()));
        deserializerMap.put("creationMode", n -> this.setCreationMode((EngagementCreationMode)n.getEnumValue(EngagementCreationMode::forValue)));
        deserializerMap.put("from", n -> this.setFrom((EngagementIdentitySet)n.getObjectValue(EngagementIdentitySet::createFromDiscriminatorValue)));
        deserializerMap.put("lastModifiedDateTime", n -> this.setLastModifiedDateTime(n.getOffsetDateTimeValue()));
        deserializerMap.put("reactions", n -> this.setReactions(n.getCollectionOfObjectValues(EngagementConversationMessageReaction::createFromDiscriminatorValue)));
        deserializerMap.put("replies", n -> this.setReplies(n.getCollectionOfObjectValues(EngagementConversationMessage::createFromDiscriminatorValue)));
        deserializerMap.put("replyTo", n -> this.setReplyTo((EngagementConversationMessage)n.getObjectValue(EngagementConversationMessage::createFromDiscriminatorValue)));
        deserializerMap.put("replyToId", n -> this.setReplyToId(n.getStringValue()));
        return deserializerMap;
    }

    @Nullable
    public EngagementIdentitySet getFrom() {
        return (EngagementIdentitySet)this.backingStore.get("from");
    }

    @Nullable
    public OffsetDateTime getLastModifiedDateTime() {
        return (OffsetDateTime)this.backingStore.get("lastModifiedDateTime");
    }

    @Nullable
    public List<EngagementConversationMessageReaction> getReactions() {
        return (List)this.backingStore.get("reactions");
    }

    @Nullable
    public List<EngagementConversationMessage> getReplies() {
        return (List)this.backingStore.get("replies");
    }

    @Nullable
    public EngagementConversationMessage getReplyTo() {
        return (EngagementConversationMessage)this.backingStore.get("replyTo");
    }

    @Nullable
    public String getReplyToId() {
        return (String)this.backingStore.get("replyToId");
    }

    @Override
    public void serialize(@Nonnull SerializationWriter writer) {
        Objects.requireNonNull(writer);
        super.serialize(writer);
        writer.writeObjectValue("body", (Parsable)this.getBody(), new Parsable[0]);
        writer.writeObjectValue("conversation", (Parsable)this.getConversation(), new Parsable[0]);
        writer.writeEnumValue("creationMode", (Enum)this.getCreationMode());
        writer.writeObjectValue("from", (Parsable)this.getFrom(), new Parsable[0]);
        writer.writeCollectionOfObjectValues("reactions", this.getReactions());
        writer.writeCollectionOfObjectValues("replies", this.getReplies());
        writer.writeObjectValue("replyTo", (Parsable)this.getReplyTo(), new Parsable[0]);
        writer.writeStringValue("replyToId", this.getReplyToId());
    }

    public void setBody(@Nullable ItemBody value) {
        this.backingStore.set("body", (Object)value);
    }

    public void setConversation(@Nullable EngagementConversation value) {
        this.backingStore.set("conversation", (Object)value);
    }

    public void setCreatedDateTime(@Nullable OffsetDateTime value) {
        this.backingStore.set("createdDateTime", (Object)value);
    }

    public void setCreationMode(@Nullable EngagementCreationMode value) {
        this.backingStore.set("creationMode", (Object)value);
    }

    public void setFrom(@Nullable EngagementIdentitySet value) {
        this.backingStore.set("from", (Object)value);
    }

    public void setLastModifiedDateTime(@Nullable OffsetDateTime value) {
        this.backingStore.set("lastModifiedDateTime", (Object)value);
    }

    public void setReactions(@Nullable List<EngagementConversationMessageReaction> value) {
        this.backingStore.set("reactions", value);
    }

    public void setReplies(@Nullable List<EngagementConversationMessage> value) {
        this.backingStore.set("replies", value);
    }

    public void setReplyTo(@Nullable EngagementConversationMessage value) {
        this.backingStore.set("replyTo", (Object)value);
    }

    public void setReplyToId(@Nullable String value) {
        this.backingStore.set("replyToId", (Object)value);
    }
}

