/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.models;

import com.microsoft.graph.models.ColumnDefinition;
import com.microsoft.graph.models.ContentTypeInfo;
import com.microsoft.graph.models.DocumentSetContent;
import com.microsoft.kiota.serialization.AdditionalDataHolder;
import com.microsoft.kiota.serialization.Parsable;
import com.microsoft.kiota.serialization.ParseNode;
import com.microsoft.kiota.serialization.SerializationWriter;
import com.microsoft.kiota.store.BackedModel;
import com.microsoft.kiota.store.BackingStore;
import com.microsoft.kiota.store.BackingStoreFactorySingleton;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;

public class DocumentSet
implements AdditionalDataHolder,
BackedModel,
Parsable {
    @Nonnull
    protected BackingStore backingStore = BackingStoreFactorySingleton.instance.createBackingStore();

    public DocumentSet() {
        this.setAdditionalData(new HashMap<String, Object>());
    }

    @Nonnull
    public static DocumentSet createFromDiscriminatorValue(@Nonnull ParseNode parseNode) {
        Objects.requireNonNull(parseNode);
        return new DocumentSet();
    }

    @Nonnull
    public Map<String, Object> getAdditionalData() {
        HashMap<String, Object> value = (HashMap<String, Object>)this.backingStore.get("additionalData");
        if (value == null) {
            value = new HashMap<String, Object>();
            this.setAdditionalData(value);
        }
        return value;
    }

    @Nullable
    public List<ContentTypeInfo> getAllowedContentTypes() {
        return (List)this.backingStore.get("allowedContentTypes");
    }

    @Nonnull
    public BackingStore getBackingStore() {
        return this.backingStore;
    }

    @Nullable
    public List<DocumentSetContent> getDefaultContents() {
        return (List)this.backingStore.get("defaultContents");
    }

    @Nonnull
    public Map<String, Consumer<ParseNode>> getFieldDeserializers() {
        HashMap<String, Consumer<ParseNode>> deserializerMap = new HashMap<String, Consumer<ParseNode>>(8);
        deserializerMap.put("allowedContentTypes", n -> this.setAllowedContentTypes(n.getCollectionOfObjectValues(ContentTypeInfo::createFromDiscriminatorValue)));
        deserializerMap.put("defaultContents", n -> this.setDefaultContents(n.getCollectionOfObjectValues(DocumentSetContent::createFromDiscriminatorValue)));
        deserializerMap.put("@odata.type", n -> this.setOdataType(n.getStringValue()));
        deserializerMap.put("propagateWelcomePageChanges", n -> this.setPropagateWelcomePageChanges(n.getBooleanValue()));
        deserializerMap.put("sharedColumns", n -> this.setSharedColumns(n.getCollectionOfObjectValues(ColumnDefinition::createFromDiscriminatorValue)));
        deserializerMap.put("shouldPrefixNameToFile", n -> this.setShouldPrefixNameToFile(n.getBooleanValue()));
        deserializerMap.put("welcomePageColumns", n -> this.setWelcomePageColumns(n.getCollectionOfObjectValues(ColumnDefinition::createFromDiscriminatorValue)));
        deserializerMap.put("welcomePageUrl", n -> this.setWelcomePageUrl(n.getStringValue()));
        return deserializerMap;
    }

    @Nullable
    public String getOdataType() {
        return (String)this.backingStore.get("odataType");
    }

    @Nullable
    public Boolean getPropagateWelcomePageChanges() {
        return (Boolean)this.backingStore.get("propagateWelcomePageChanges");
    }

    @Nullable
    public List<ColumnDefinition> getSharedColumns() {
        return (List)this.backingStore.get("sharedColumns");
    }

    @Nullable
    public Boolean getShouldPrefixNameToFile() {
        return (Boolean)this.backingStore.get("shouldPrefixNameToFile");
    }

    @Nullable
    public List<ColumnDefinition> getWelcomePageColumns() {
        return (List)this.backingStore.get("welcomePageColumns");
    }

    @Nullable
    public String getWelcomePageUrl() {
        return (String)this.backingStore.get("welcomePageUrl");
    }

    public void serialize(@Nonnull SerializationWriter writer) {
        Objects.requireNonNull(writer);
        writer.writeCollectionOfObjectValues("allowedContentTypes", this.getAllowedContentTypes());
        writer.writeCollectionOfObjectValues("defaultContents", this.getDefaultContents());
        writer.writeStringValue("@odata.type", this.getOdataType());
        writer.writeBooleanValue("propagateWelcomePageChanges", this.getPropagateWelcomePageChanges());
        writer.writeCollectionOfObjectValues("sharedColumns", this.getSharedColumns());
        writer.writeBooleanValue("shouldPrefixNameToFile", this.getShouldPrefixNameToFile());
        writer.writeCollectionOfObjectValues("welcomePageColumns", this.getWelcomePageColumns());
        writer.writeStringValue("welcomePageUrl", this.getWelcomePageUrl());
        writer.writeAdditionalData(this.getAdditionalData());
    }

    public void setAdditionalData(@Nullable Map<String, Object> value) {
        this.backingStore.set("additionalData", value);
    }

    public void setAllowedContentTypes(@Nullable List<ContentTypeInfo> value) {
        this.backingStore.set("allowedContentTypes", value);
    }

    public void setBackingStore(@Nonnull BackingStore value) {
        Objects.requireNonNull(value);
        this.backingStore = value;
    }

    public void setDefaultContents(@Nullable List<DocumentSetContent> value) {
        this.backingStore.set("defaultContents", value);
    }

    public void setOdataType(@Nullable String value) {
        this.backingStore.set("odataType", (Object)value);
    }

    public void setPropagateWelcomePageChanges(@Nullable Boolean value) {
        this.backingStore.set("propagateWelcomePageChanges", (Object)value);
    }

    public void setSharedColumns(@Nullable List<ColumnDefinition> value) {
        this.backingStore.set("sharedColumns", value);
    }

    public void setShouldPrefixNameToFile(@Nullable Boolean value) {
        this.backingStore.set("shouldPrefixNameToFile", (Object)value);
    }

    public void setWelcomePageColumns(@Nullable List<ColumnDefinition> value) {
        this.backingStore.set("welcomePageColumns", value);
    }

    public void setWelcomePageUrl(@Nullable String value) {
        this.backingStore.set("welcomePageUrl", (Object)value);
    }
}

