/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.models;

import com.microsoft.graph.models.AccessPackageDynamicApprovalStage;
import com.microsoft.graph.models.SubjectSet;
import com.microsoft.kiota.PeriodAndDuration;
import com.microsoft.kiota.serialization.AdditionalDataHolder;
import com.microsoft.kiota.serialization.Parsable;
import com.microsoft.kiota.serialization.ParseNode;
import com.microsoft.kiota.serialization.SerializationWriter;
import com.microsoft.kiota.store.BackedModel;
import com.microsoft.kiota.store.BackingStore;
import com.microsoft.kiota.store.BackingStoreFactorySingleton;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;

public class AccessPackageApprovalStage
implements AdditionalDataHolder,
BackedModel,
Parsable {
    @Nonnull
    protected BackingStore backingStore = BackingStoreFactorySingleton.instance.createBackingStore();

    public AccessPackageApprovalStage() {
        this.setAdditionalData(new HashMap<String, Object>());
    }

    @Nonnull
    public static AccessPackageApprovalStage createFromDiscriminatorValue(@Nonnull ParseNode parseNode) {
        Objects.requireNonNull(parseNode);
        ParseNode mappingValueNode = parseNode.getChildNode("@odata.type");
        if (mappingValueNode != null) {
            String mappingValue;
            switch (mappingValue = mappingValueNode.getStringValue()) {
                case "#microsoft.graph.accessPackageDynamicApprovalStage": {
                    return new AccessPackageDynamicApprovalStage();
                }
            }
        }
        return new AccessPackageApprovalStage();
    }

    @Nonnull
    public Map<String, Object> getAdditionalData() {
        HashMap<String, Object> value = (HashMap<String, Object>)this.backingStore.get("additionalData");
        if (value == null) {
            value = new HashMap<String, Object>();
            this.setAdditionalData(value);
        }
        return value;
    }

    @Nonnull
    public BackingStore getBackingStore() {
        return this.backingStore;
    }

    @Nullable
    public PeriodAndDuration getDurationBeforeAutomaticDenial() {
        return (PeriodAndDuration)this.backingStore.get("durationBeforeAutomaticDenial");
    }

    @Nullable
    public PeriodAndDuration getDurationBeforeEscalation() {
        return (PeriodAndDuration)this.backingStore.get("durationBeforeEscalation");
    }

    @Nullable
    public List<SubjectSet> getEscalationApprovers() {
        return (List)this.backingStore.get("escalationApprovers");
    }

    @Nullable
    public List<SubjectSet> getFallbackEscalationApprovers() {
        return (List)this.backingStore.get("fallbackEscalationApprovers");
    }

    @Nullable
    public List<SubjectSet> getFallbackPrimaryApprovers() {
        return (List)this.backingStore.get("fallbackPrimaryApprovers");
    }

    @Nonnull
    public Map<String, Consumer<ParseNode>> getFieldDeserializers() {
        HashMap<String, Consumer<ParseNode>> deserializerMap = new HashMap<String, Consumer<ParseNode>>(9);
        deserializerMap.put("durationBeforeAutomaticDenial", n -> this.setDurationBeforeAutomaticDenial(n.getPeriodAndDurationValue()));
        deserializerMap.put("durationBeforeEscalation", n -> this.setDurationBeforeEscalation(n.getPeriodAndDurationValue()));
        deserializerMap.put("escalationApprovers", n -> this.setEscalationApprovers(n.getCollectionOfObjectValues(SubjectSet::createFromDiscriminatorValue)));
        deserializerMap.put("fallbackEscalationApprovers", n -> this.setFallbackEscalationApprovers(n.getCollectionOfObjectValues(SubjectSet::createFromDiscriminatorValue)));
        deserializerMap.put("fallbackPrimaryApprovers", n -> this.setFallbackPrimaryApprovers(n.getCollectionOfObjectValues(SubjectSet::createFromDiscriminatorValue)));
        deserializerMap.put("isApproverJustificationRequired", n -> this.setIsApproverJustificationRequired(n.getBooleanValue()));
        deserializerMap.put("isEscalationEnabled", n -> this.setIsEscalationEnabled(n.getBooleanValue()));
        deserializerMap.put("@odata.type", n -> this.setOdataType(n.getStringValue()));
        deserializerMap.put("primaryApprovers", n -> this.setPrimaryApprovers(n.getCollectionOfObjectValues(SubjectSet::createFromDiscriminatorValue)));
        return deserializerMap;
    }

    @Nullable
    public Boolean getIsApproverJustificationRequired() {
        return (Boolean)this.backingStore.get("isApproverJustificationRequired");
    }

    @Nullable
    public Boolean getIsEscalationEnabled() {
        return (Boolean)this.backingStore.get("isEscalationEnabled");
    }

    @Nullable
    public String getOdataType() {
        return (String)this.backingStore.get("odataType");
    }

    @Nullable
    public List<SubjectSet> getPrimaryApprovers() {
        return (List)this.backingStore.get("primaryApprovers");
    }

    public void serialize(@Nonnull SerializationWriter writer) {
        Objects.requireNonNull(writer);
        writer.writePeriodAndDurationValue("durationBeforeAutomaticDenial", this.getDurationBeforeAutomaticDenial());
        writer.writePeriodAndDurationValue("durationBeforeEscalation", this.getDurationBeforeEscalation());
        writer.writeCollectionOfObjectValues("escalationApprovers", this.getEscalationApprovers());
        writer.writeCollectionOfObjectValues("fallbackEscalationApprovers", this.getFallbackEscalationApprovers());
        writer.writeCollectionOfObjectValues("fallbackPrimaryApprovers", this.getFallbackPrimaryApprovers());
        writer.writeBooleanValue("isApproverJustificationRequired", this.getIsApproverJustificationRequired());
        writer.writeBooleanValue("isEscalationEnabled", this.getIsEscalationEnabled());
        writer.writeStringValue("@odata.type", this.getOdataType());
        writer.writeCollectionOfObjectValues("primaryApprovers", this.getPrimaryApprovers());
        writer.writeAdditionalData(this.getAdditionalData());
    }

    public void setAdditionalData(@Nullable Map<String, Object> value) {
        this.backingStore.set("additionalData", value);
    }

    public void setBackingStore(@Nonnull BackingStore value) {
        Objects.requireNonNull(value);
        this.backingStore = value;
    }

    public void setDurationBeforeAutomaticDenial(@Nullable PeriodAndDuration value) {
        this.backingStore.set("durationBeforeAutomaticDenial", (Object)value);
    }

    public void setDurationBeforeEscalation(@Nullable PeriodAndDuration value) {
        this.backingStore.set("durationBeforeEscalation", (Object)value);
    }

    public void setEscalationApprovers(@Nullable List<SubjectSet> value) {
        this.backingStore.set("escalationApprovers", value);
    }

    public void setFallbackEscalationApprovers(@Nullable List<SubjectSet> value) {
        this.backingStore.set("fallbackEscalationApprovers", value);
    }

    public void setFallbackPrimaryApprovers(@Nullable List<SubjectSet> value) {
        this.backingStore.set("fallbackPrimaryApprovers", value);
    }

    public void setIsApproverJustificationRequired(@Nullable Boolean value) {
        this.backingStore.set("isApproverJustificationRequired", (Object)value);
    }

    public void setIsEscalationEnabled(@Nullable Boolean value) {
        this.backingStore.set("isEscalationEnabled", (Object)value);
    }

    public void setOdataType(@Nullable String value) {
        this.backingStore.set("odataType", (Object)value);
    }

    public void setPrimaryApprovers(@Nullable List<SubjectSet> value) {
        this.backingStore.set("primaryApprovers", value);
    }
}

