package com.microsoft.graph.beta.models;

import com.microsoft.kiota.serialization.Parsable;
import com.microsoft.kiota.serialization.ParseNode;
import com.microsoft.kiota.serialization.SerializationWriter;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
@jakarta.annotation.Generated("com.microsoft.kiota")
public class DlpWindowsDevicesNotification extends DlpNotification implements Parsable {
    /**
     * Instantiates a new {@link DlpWindowsDevicesNotification} and sets the default values.
     */
    public DlpWindowsDevicesNotification() {
        super();
        this.setOdataType("#microsoft.graph.dlpWindowsDevicesNotification");
    }
    /**
     * Creates a new instance of the appropriate class based on discriminator value
     * @param parseNode The parse node to use to read the discriminator value and create the object
     * @return a {@link DlpWindowsDevicesNotification}
     */
    @jakarta.annotation.Nonnull
    public static DlpWindowsDevicesNotification createFromDiscriminatorValue(@jakarta.annotation.Nonnull final ParseNode parseNode) {
        Objects.requireNonNull(parseNode);
        return new DlpWindowsDevicesNotification();
    }
    /**
     * Gets the contentName property value. The contentName property
     * @return a {@link String}
     */
    @jakarta.annotation.Nullable
    public String getContentName() {
        return this.backingStore.get("contentName");
    }
    /**
     * The deserialization information for the current model
     * @return a {@link Map<String, java.util.function.Consumer<ParseNode>>}
     */
    @jakarta.annotation.Nonnull
    public Map<String, java.util.function.Consumer<ParseNode>> getFieldDeserializers() {
        final HashMap<String, java.util.function.Consumer<ParseNode>> deserializerMap = new HashMap<String, java.util.function.Consumer<ParseNode>>(super.getFieldDeserializers());
        deserializerMap.put("contentName", (n) -> { this.setContentName(n.getStringValue()); });
        deserializerMap.put("lastModfiedBy", (n) -> { this.setLastModfiedBy(n.getStringValue()); });
        return deserializerMap;
    }
    /**
     * Gets the lastModfiedBy property value. The lastModfiedBy property
     * @return a {@link String}
     */
    @jakarta.annotation.Nullable
    public String getLastModfiedBy() {
        return this.backingStore.get("lastModfiedBy");
    }
    /**
     * Serializes information the current object
     * @param writer Serialization writer to use to serialize this model
     */
    public void serialize(@jakarta.annotation.Nonnull final SerializationWriter writer) {
        Objects.requireNonNull(writer);
        super.serialize(writer);
        writer.writeStringValue("contentName", this.getContentName());
        writer.writeStringValue("lastModfiedBy", this.getLastModfiedBy());
    }
    /**
     * Sets the contentName property value. The contentName property
     * @param value Value to set for the contentName property.
     */
    public void setContentName(@jakarta.annotation.Nullable final String value) {
        this.backingStore.set("contentName", value);
    }
    /**
     * Sets the lastModfiedBy property value. The lastModfiedBy property
     * @param value Value to set for the lastModfiedBy property.
     */
    public void setLastModfiedBy(@jakarta.annotation.Nullable final String value) {
        this.backingStore.set("lastModfiedBy", value);
    }
}
