package com.microsoft.graph.beta.models;

import com.microsoft.kiota.serialization.Parsable;
import com.microsoft.kiota.serialization.ParseNode;
import com.microsoft.kiota.serialization.SerializationWriter;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
@jakarta.annotation.Generated("com.microsoft.kiota")
public class OutlookCategory extends Entity implements Parsable {
    /**
     * Instantiates a new {@link OutlookCategory} and sets the default values.
     */
    public OutlookCategory() {
        super();
    }
    /**
     * Creates a new instance of the appropriate class based on discriminator value
     * @param parseNode The parse node to use to read the discriminator value and create the object
     * @return a {@link OutlookCategory}
     */
    @jakarta.annotation.Nonnull
    public static OutlookCategory createFromDiscriminatorValue(@jakarta.annotation.Nonnull final ParseNode parseNode) {
        Objects.requireNonNull(parseNode);
        return new OutlookCategory();
    }
    /**
     * Gets the color property value. A preset color constant that characterizes a category, and that is mapped to one of 25 predefined colors. For more information, see the following note.
     * @return a {@link CategoryColor}
     */
    @jakarta.annotation.Nullable
    public CategoryColor getColor() {
        return this.backingStore.get("color");
    }
    /**
     * Gets the displayName property value. A unique name that identifies a category in the user&apos;s mailbox. After a category is created, the name can&apos;t be changed. Read-only.
     * @return a {@link String}
     */
    @jakarta.annotation.Nullable
    public String getDisplayName() {
        return this.backingStore.get("displayName");
    }
    /**
     * The deserialization information for the current model
     * @return a {@link Map<String, java.util.function.Consumer<ParseNode>>}
     */
    @jakarta.annotation.Nonnull
    public Map<String, java.util.function.Consumer<ParseNode>> getFieldDeserializers() {
        final HashMap<String, java.util.function.Consumer<ParseNode>> deserializerMap = new HashMap<String, java.util.function.Consumer<ParseNode>>(super.getFieldDeserializers());
        deserializerMap.put("color", (n) -> { this.setColor(n.getEnumValue(CategoryColor::forValue)); });
        deserializerMap.put("displayName", (n) -> { this.setDisplayName(n.getStringValue()); });
        return deserializerMap;
    }
    /**
     * Serializes information the current object
     * @param writer Serialization writer to use to serialize this model
     */
    public void serialize(@jakarta.annotation.Nonnull final SerializationWriter writer) {
        Objects.requireNonNull(writer);
        super.serialize(writer);
        writer.writeEnumValue("color", this.getColor());
        writer.writeStringValue("displayName", this.getDisplayName());
    }
    /**
     * Sets the color property value. A preset color constant that characterizes a category, and that is mapped to one of 25 predefined colors. For more information, see the following note.
     * @param value Value to set for the color property.
     */
    public void setColor(@jakarta.annotation.Nullable final CategoryColor value) {
        this.backingStore.set("color", value);
    }
    /**
     * Sets the displayName property value. A unique name that identifies a category in the user&apos;s mailbox. After a category is created, the name can&apos;t be changed. Read-only.
     * @param value Value to set for the displayName property.
     */
    public void setDisplayName(@jakarta.annotation.Nullable final String value) {
        this.backingStore.set("displayName", value);
    }
}
