package com.microsoft.graph.beta.models;

import com.microsoft.kiota.serialization.ValuedEnum;
import java.util.Objects;

/**
 * Malware category id
 */
@jakarta.annotation.Generated("com.microsoft.kiota")
public enum WindowsMalwareCategory implements ValuedEnum {
    /** Invalid */
    Invalid("invalid"),
    /** Adware */
    Adware("adware"),
    /** Spyware */
    Spyware("spyware"),
    /** Password stealer */
    PasswordStealer("passwordStealer"),
    /** Trojan downloader */
    TrojanDownloader("trojanDownloader"),
    /** Worm */
    Worm("worm"),
    /** Backdoor */
    Backdoor("backdoor"),
    /** Remote access Trojan */
    RemoteAccessTrojan("remoteAccessTrojan"),
    /** Trojan */
    Trojan("trojan"),
    /** Email flooder */
    EmailFlooder("emailFlooder"),
    /** Keylogger */
    Keylogger("keylogger"),
    /** Dialer */
    Dialer("dialer"),
    /** Monitoring software */
    MonitoringSoftware("monitoringSoftware"),
    /** Browser modifier */
    BrowserModifier("browserModifier"),
    /** Cookie */
    Cookie("cookie"),
    /** Browser plugin */
    BrowserPlugin("browserPlugin"),
    /** AOL exploit */
    AolExploit("aolExploit"),
    /** Nuker */
    Nuker("nuker"),
    /** Security disabler */
    SecurityDisabler("securityDisabler"),
    /** Joke program */
    JokeProgram("jokeProgram"),
    /** Hostile ActiveX control */
    HostileActiveXControl("hostileActiveXControl"),
    /** Software bundler */
    SoftwareBundler("softwareBundler"),
    /** Stealth modifier */
    StealthNotifier("stealthNotifier"),
    /** Settings modifier */
    SettingsModifier("settingsModifier"),
    /** Toolbar */
    ToolBar("toolBar"),
    /** Remote control software */
    RemoteControlSoftware("remoteControlSoftware"),
    /** Trojan FTP */
    TrojanFtp("trojanFtp"),
    /** Potential unwanted software */
    PotentialUnwantedSoftware("potentialUnwantedSoftware"),
    /** ICQ exploit */
    IcqExploit("icqExploit"),
    /** Trojan telnet */
    TrojanTelnet("trojanTelnet"),
    /** Exploit */
    Exploit("exploit"),
    /** File sharing program */
    FilesharingProgram("filesharingProgram"),
    /** Malware creation tool */
    MalwareCreationTool("malwareCreationTool"),
    /** Remote control software */
    Remote_Control_Software("remote_Control_Software"),
    /** Tool */
    Tool("tool"),
    /** Trojan denial of service */
    TrojanDenialOfService("trojanDenialOfService"),
    /** Trojan dropper */
    TrojanDropper("trojanDropper"),
    /** Trojan mass mailer */
    TrojanMassMailer("trojanMassMailer"),
    /** Trojan monitoring software */
    TrojanMonitoringSoftware("trojanMonitoringSoftware"),
    /** Trojan proxy server */
    TrojanProxyServer("trojanProxyServer"),
    /** Virus */
    Virus("virus"),
    /** Known */
    Known("known"),
    /** Unknown */
    Unknown("unknown"),
    /** SPP */
    Spp("spp"),
    /** Behavior */
    Behavior("behavior"),
    /** Vulnerability */
    Vulnerability("vulnerability"),
    /** Policy */
    Policy("policy"),
    /** Enterprise Unwanted Software */
    EnterpriseUnwantedSoftware("enterpriseUnwantedSoftware"),
    /** Ransom */
    Ransom("ransom"),
    /** HIPS Rule */
    HipsRule("hipsRule");
    public final String value;
    WindowsMalwareCategory(final String value) {
        this.value = value;
    }
    @jakarta.annotation.Nonnull
    public String getValue() { return this.value; }
    @jakarta.annotation.Nullable
    public static WindowsMalwareCategory forValue(@jakarta.annotation.Nonnull final String searchValue) {
        Objects.requireNonNull(searchValue);
        switch(searchValue) {
            case "invalid": return Invalid;
            case "adware": return Adware;
            case "spyware": return Spyware;
            case "passwordStealer": return PasswordStealer;
            case "trojanDownloader": return TrojanDownloader;
            case "worm": return Worm;
            case "backdoor": return Backdoor;
            case "remoteAccessTrojan": return RemoteAccessTrojan;
            case "trojan": return Trojan;
            case "emailFlooder": return EmailFlooder;
            case "keylogger": return Keylogger;
            case "dialer": return Dialer;
            case "monitoringSoftware": return MonitoringSoftware;
            case "browserModifier": return BrowserModifier;
            case "cookie": return Cookie;
            case "browserPlugin": return BrowserPlugin;
            case "aolExploit": return AolExploit;
            case "nuker": return Nuker;
            case "securityDisabler": return SecurityDisabler;
            case "jokeProgram": return JokeProgram;
            case "hostileActiveXControl": return HostileActiveXControl;
            case "softwareBundler": return SoftwareBundler;
            case "stealthNotifier": return StealthNotifier;
            case "settingsModifier": return SettingsModifier;
            case "toolBar": return ToolBar;
            case "remoteControlSoftware": return RemoteControlSoftware;
            case "trojanFtp": return TrojanFtp;
            case "potentialUnwantedSoftware": return PotentialUnwantedSoftware;
            case "icqExploit": return IcqExploit;
            case "trojanTelnet": return TrojanTelnet;
            case "exploit": return Exploit;
            case "filesharingProgram": return FilesharingProgram;
            case "malwareCreationTool": return MalwareCreationTool;
            case "remote_Control_Software": return Remote_Control_Software;
            case "tool": return Tool;
            case "trojanDenialOfService": return TrojanDenialOfService;
            case "trojanDropper": return TrojanDropper;
            case "trojanMassMailer": return TrojanMassMailer;
            case "trojanMonitoringSoftware": return TrojanMonitoringSoftware;
            case "trojanProxyServer": return TrojanProxyServer;
            case "virus": return Virus;
            case "known": return Known;
            case "unknown": return Unknown;
            case "spp": return Spp;
            case "behavior": return Behavior;
            case "vulnerability": return Vulnerability;
            case "policy": return Policy;
            case "enterpriseUnwantedSoftware": return EnterpriseUnwantedSoftware;
            case "ransom": return Ransom;
            case "hipsRule": return HipsRule;
            default: return null;
        }
    }
}
