/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.bot.builder.inspection;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.microsoft.bot.builder.ConversationState;
import com.microsoft.bot.builder.MessageFactory;
import com.microsoft.bot.builder.StatePropertyAccessor;
import com.microsoft.bot.builder.TurnContext;
import com.microsoft.bot.builder.UserState;
import com.microsoft.bot.builder.inspection.InspectionActivityExtensions;
import com.microsoft.bot.builder.inspection.InspectionSession;
import com.microsoft.bot.builder.inspection.InspectionSessionsByStatus;
import com.microsoft.bot.builder.inspection.InspectionState;
import com.microsoft.bot.builder.inspection.InterceptionMiddleware;
import com.microsoft.bot.connector.authentication.MicrosoftAppCredentials;
import com.microsoft.bot.schema.Activity;
import com.microsoft.bot.schema.ConversationReference;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.LoggerFactory;

public class InspectionMiddleware
extends InterceptionMiddleware {
    private static final String COMMAND = "/INSPECT";
    private InspectionState inspectionState;
    private UserState userState;
    private ConversationState conversationState;
    private MicrosoftAppCredentials credentials;

    public InspectionMiddleware(InspectionState withInspectionState) {
        this(withInspectionState, null, null, null);
    }

    public InspectionMiddleware(InspectionState withInspectionState, UserState withUserState, ConversationState withConversationState, MicrosoftAppCredentials withCredentials) {
        super(LoggerFactory.getLogger(InspectionMiddleware.class));
        this.inspectionState = withInspectionState;
        this.userState = withUserState;
        this.conversationState = withConversationState;
        this.credentials = withCredentials != null ? withCredentials : MicrosoftAppCredentials.empty();
    }

    public CompletableFuture<Boolean> processCommand(TurnContext turnContext) {
        if (!turnContext.getActivity().isType("message") || StringUtils.isEmpty((CharSequence)turnContext.getActivity().getText())) {
            return CompletableFuture.completedFuture(false);
        }
        String text = Activity.removeRecipientMentionImmutable((Activity)turnContext.getActivity());
        String[] command = text.split(" ");
        if (command.length > 1 && StringUtils.equals((CharSequence)command[0], (CharSequence)COMMAND)) {
            if (command.length == 2 && StringUtils.equals((CharSequence)command[1], (CharSequence)"open")) {
                return this.processOpenCommand(turnContext).thenApply(result -> true);
            }
            if (command.length == 3 && StringUtils.equals((CharSequence)command[1], (CharSequence)"attach")) {
                return this.processAttachCommand(turnContext, command[2]).thenApply(result -> true);
            }
        }
        return CompletableFuture.completedFuture(false);
    }

    @Override
    protected CompletableFuture<InterceptionMiddleware.Intercept> inbound(TurnContext turnContext, Activity activity) {
        return this.processCommand(turnContext).thenCompose(processResult -> {
            if (processResult.booleanValue()) {
                return CompletableFuture.completedFuture(new InterceptionMiddleware.Intercept(false, false));
            }
            return this.findSession(turnContext).thenCompose(session -> {
                if (session == null) {
                    return CompletableFuture.completedFuture(new InterceptionMiddleware.Intercept(true, false));
                }
                return this.invokeSend(turnContext, (InspectionSession)session, activity).thenCompose(invokeResult -> {
                    if (invokeResult.booleanValue()) {
                        return CompletableFuture.completedFuture(new InterceptionMiddleware.Intercept(true, true));
                    }
                    return CompletableFuture.completedFuture(new InterceptionMiddleware.Intercept(true, false));
                });
            });
        });
    }

    @Override
    protected CompletableFuture<Void> outbound(TurnContext turnContext, List<Activity> clonedActivities) {
        return this.findSession(turnContext).thenCompose(session -> {
            if (session != null) {
                ArrayList<CompletableFuture<Boolean>> sends = new ArrayList<CompletableFuture<Boolean>>();
                for (Activity traceActivity : clonedActivities) {
                    sends.add(this.invokeSend(turnContext, (InspectionSession)session, traceActivity));
                }
                return CompletableFuture.allOf(sends.toArray(new CompletableFuture[sends.size()]));
            }
            return CompletableFuture.completedFuture(null);
        });
    }

    @Override
    protected CompletableFuture<Void> traceState(TurnContext turnContext) {
        return this.findSession(turnContext).thenCompose(session -> {
            if (session == null) {
                return CompletableFuture.completedFuture(null);
            }
            CompletableFuture<Object> userLoad = this.userState == null ? CompletableFuture.completedFuture(null) : this.userState.load(turnContext);
            CompletableFuture<Object> conversationLoad = this.conversationState == null ? CompletableFuture.completedFuture(null) : this.conversationState.load(turnContext);
            return CompletableFuture.allOf(userLoad, conversationLoad).thenCompose(loadResult -> {
                ObjectNode botState = JsonNodeFactory.instance.objectNode();
                if (this.userState != null) {
                    botState.set("userState", this.userState.get(turnContext));
                }
                if (this.conversationState != null) {
                    botState.set("conversationState", this.conversationState.get(turnContext));
                }
                return this.invokeSend(turnContext, (InspectionSession)session, InspectionActivityExtensions.traceActivity((JsonNode)botState)).thenCompose(invokeResult -> CompletableFuture.completedFuture(null));
            });
        });
    }

    private CompletableFuture<Void> processOpenCommand(TurnContext turnContext) {
        StatePropertyAccessor<InspectionSessionsByStatus> accessor = this.inspectionState.createProperty(InspectionSessionsByStatus.class.getName());
        return ((CompletableFuture)accessor.get(turnContext, InspectionSessionsByStatus::new).thenCompose(result -> {
            InspectionSessionsByStatus sessions = result;
            String sessionId = this.openCommand(sessions, turnContext.getActivity().getConversationReference());
            String command = String.format("%s attach %s", COMMAND, sessionId);
            return turnContext.sendActivity(InspectionActivityExtensions.makeCommandActivity(command));
        })).thenCompose(resourceResponse -> this.inspectionState.saveChanges(turnContext));
    }

    private CompletableFuture<Void> processAttachCommand(TurnContext turnContext, String sessionId) {
        StatePropertyAccessor<InspectionSessionsByStatus> accessor = this.inspectionState.createProperty(InspectionSessionsByStatus.class.getName());
        return ((CompletableFuture)accessor.get(turnContext, InspectionSessionsByStatus::new).thenCompose(sessions -> {
            if (this.attachCommand(turnContext.getActivity().getConversation().getId(), (InspectionSessionsByStatus)sessions, sessionId)) {
                return turnContext.sendActivity(MessageFactory.text("Attached to session, all traffic is being replicated for inspection."));
            }
            return turnContext.sendActivity(MessageFactory.text(String.format("Open session with id %s does not exist.", sessionId)));
        })).thenCompose(resourceResponse -> this.inspectionState.saveChanges(turnContext));
    }

    private String openCommand(InspectionSessionsByStatus sessions, ConversationReference conversationReference) {
        String sessionId = UUID.randomUUID().toString();
        sessions.getOpenedSessions().put(sessionId, conversationReference);
        return sessionId;
    }

    private boolean attachCommand(String conversationId, InspectionSessionsByStatus sessions, String sessionId) {
        ConversationReference inspectionSessionState = sessions.getOpenedSessions().get(sessionId);
        if (inspectionSessionState == null) {
            return false;
        }
        sessions.getAttachedSessions().put(conversationId, inspectionSessionState);
        sessions.getOpenedSessions().remove(sessionId);
        return true;
    }

    protected InspectionSession createSession(ConversationReference reference, MicrosoftAppCredentials credentials) {
        return new InspectionSession(reference, credentials);
    }

    private CompletableFuture<InspectionSession> findSession(TurnContext turnContext) {
        StatePropertyAccessor<InspectionSessionsByStatus> accessor = this.inspectionState.createProperty(InspectionSessionsByStatus.class.getName());
        return accessor.get(turnContext, InspectionSessionsByStatus::new).thenApply(openSessions -> {
            ConversationReference reference = openSessions.getAttachedSessions().get(turnContext.getActivity().getConversation().getId());
            if (reference != null) {
                return this.createSession(reference, this.credentials);
            }
            return null;
        });
    }

    private CompletableFuture<Boolean> invokeSend(TurnContext turnContext, InspectionSession session, Activity activity) {
        return session.send(activity).thenCompose(result -> {
            if (result.booleanValue()) {
                return CompletableFuture.completedFuture(true);
            }
            return this.cleanupSession(turnContext).thenCompose(cleanupResult -> CompletableFuture.completedFuture(false));
        });
    }

    private CompletableFuture<Void> cleanupSession(TurnContext turnContext) {
        StatePropertyAccessor<InspectionSessionsByStatus> accessor = this.inspectionState.createProperty(InspectionSessionsByStatus.class.getName());
        return accessor.get(turnContext, InspectionSessionsByStatus::new).thenCompose(result -> {
            InspectionSessionsByStatus openSessions = result;
            openSessions.getAttachedSessions().remove(turnContext.getActivity().getConversation().getId());
            return this.inspectionState.saveChanges(turnContext);
        });
    }
}

