/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.bot.builder;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.microsoft.bot.builder.BotTelemetryClient;
import com.microsoft.bot.builder.Middleware;
import com.microsoft.bot.builder.NextDelegate;
import com.microsoft.bot.builder.NullBotTelemetryClient;
import com.microsoft.bot.builder.TurnContext;
import com.microsoft.bot.connector.Async;
import com.microsoft.bot.schema.Activity;
import com.microsoft.bot.schema.ConversationReference;
import com.microsoft.bot.schema.ResourceResponse;
import com.microsoft.bot.schema.ResultPair;
import com.microsoft.bot.schema.Serialization;
import com.microsoft.bot.schema.teams.TeamsChannelData;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.function.Supplier;
import org.apache.commons.lang3.StringUtils;

public class TelemetryLoggerMiddleware
implements Middleware {
    private boolean logPersonalInformation;
    private BotTelemetryClient telemetryClient;

    public TelemetryLoggerMiddleware(BotTelemetryClient withTelemetryClient, boolean withLogPersonalInformation) {
        this.telemetryClient = withTelemetryClient == null ? new NullBotTelemetryClient() : withTelemetryClient;
        this.logPersonalInformation = withLogPersonalInformation;
    }

    public BotTelemetryClient getTelemetryClient() {
        return this.telemetryClient;
    }

    @Override
    public CompletableFuture<Void> onTurn(TurnContext context, NextDelegate next) {
        if (context == null) {
            return Async.completeExceptionally((Throwable)new IllegalArgumentException("TurnContext"));
        }
        return this.onReceiveActivity(context.getActivity()).thenCompose(receiveResult -> {
            context.onSendActivities((sendContext, sendActivities, sendNext) -> ((CompletableFuture)sendNext.get()).thenApply(responses -> {
                for (Activity sendActivity : sendActivities) {
                    this.onSendActivity(sendActivity);
                }
                return responses;
            }));
            context.onUpdateActivity((TurnContext updateContext, Activity updateActivity, Supplier<CompletableFuture<ResourceResponse>> updateNext) -> ((CompletableFuture)updateNext.get()).thenCombine(this.onUpdateActivity(updateActivity), (resourceResponse, updateResult) -> resourceResponse));
            context.onDeleteActivity((TurnContext deleteContext, ConversationReference deleteReference, Supplier<CompletableFuture<Void>> deleteNext) -> ((CompletableFuture)deleteNext.get()).thenCompose(nextResult -> {
                Activity deleteActivity = new Activity("messageDelete");
                deleteActivity.setId(deleteReference.getActivityId());
                deleteActivity.applyConversationReference(deleteReference, false);
                return this.onDeleteActivity(deleteActivity);
            }));
            if (next != null) {
                return next.next();
            }
            return CompletableFuture.completedFuture(null);
        });
    }

    protected CompletableFuture<Void> onReceiveActivity(Activity activity) {
        if (activity == null) {
            return CompletableFuture.completedFuture(null);
        }
        return this.fillReceiveEventProperties(activity, null).thenAccept(properties -> this.telemetryClient.trackEvent("BotMessageReceived", (Map<String, String>)properties));
    }

    protected CompletableFuture<Void> onSendActivity(Activity activity) {
        return this.fillSendEventProperties(activity, null).thenAccept(properties -> this.telemetryClient.trackEvent("BotMessageSend", (Map<String, String>)properties));
    }

    protected CompletableFuture<Void> onUpdateActivity(Activity activity) {
        return this.fillUpdateEventProperties(activity, null).thenAccept(properties -> this.telemetryClient.trackEvent("BotMessageUpdate", (Map<String, String>)properties));
    }

    protected CompletableFuture<Void> onDeleteActivity(Activity activity) {
        return this.fillDeleteEventProperties(activity, null).thenAccept(properties -> this.telemetryClient.trackEvent("BotMessageDelete", (Map<String, String>)properties));
    }

    protected CompletableFuture<Map<String, String>> fillReceiveEventProperties(Activity activity, Map<String, String> additionalProperties) {
        HashMap<String, String> properties = new HashMap<String, String>();
        String fromId = activity.getFrom().getId() != null ? activity.getFrom().getId() : "";
        properties.put("fromId", fromId);
        String conversationName = activity.getConversation().getName() != null ? activity.getConversation().getName() : "";
        properties.put("conversationName", conversationName);
        String activityLocale = activity.getLocale() != null ? activity.getLocale() : "";
        properties.put("locale", activityLocale);
        String recipientId = activity.getRecipient().getId() != null ? activity.getRecipient().getId() : "";
        properties.put("recipientId", recipientId);
        String recipientName = activity.getRecipient().getName() != null ? activity.getRecipient().getName() : "";
        properties.put("recipientName", recipientName);
        if (this.logPersonalInformation) {
            if (!StringUtils.isEmpty((CharSequence)activity.getFrom().getName())) {
                properties.put("fromName", activity.getFrom().getName());
            }
            if (!StringUtils.isEmpty((CharSequence)activity.getText())) {
                properties.put("text", activity.getText());
            }
            if (!StringUtils.isEmpty((CharSequence)activity.getSpeak())) {
                properties.put("speak", activity.getSpeak());
            }
            if (activity.getAttachments() != null && activity.getAttachments().size() > 0) {
                try {
                    properties.put("attachments", Serialization.toString((Object)activity.getAttachments()));
                }
                catch (JsonProcessingException jsonProcessingException) {
                    // empty catch block
                }
            }
        }
        this.populateAdditionalChannelProperties(activity, properties);
        if (additionalProperties != null) {
            properties.putAll(additionalProperties);
        }
        return CompletableFuture.completedFuture(properties);
    }

    protected CompletableFuture<Map<String, String>> fillSendEventProperties(Activity activity, Map<String, String> additionalProperties) {
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put("replyActivityId", activity.getReplyToId());
        properties.put("recipientId", activity.getRecipient().getId());
        properties.put("conversationName", activity.getConversation().getName());
        properties.put("locale", activity.getLocale());
        if (this.logPersonalInformation) {
            if (!StringUtils.isEmpty((CharSequence)activity.getRecipient().getName())) {
                properties.put("recipientName", activity.getRecipient().getName());
            }
            if (!StringUtils.isEmpty((CharSequence)activity.getText())) {
                properties.put("text", activity.getText());
            }
            if (!StringUtils.isEmpty((CharSequence)activity.getSpeak())) {
                properties.put("speak", activity.getSpeak());
            }
        }
        if (additionalProperties != null) {
            properties.putAll(additionalProperties);
        }
        return CompletableFuture.completedFuture(properties);
    }

    protected CompletableFuture<Map<String, String>> fillUpdateEventProperties(Activity activity, Map<String, String> additionalProperties) {
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put("recipientId", activity.getRecipient().getId());
        properties.put("conversationId", activity.getConversation().getId());
        properties.put("conversationName", activity.getConversation().getName());
        properties.put("locale", activity.getLocale());
        if (this.logPersonalInformation && !StringUtils.isEmpty((CharSequence)activity.getText())) {
            properties.put("text", activity.getText());
        }
        if (additionalProperties != null) {
            properties.putAll(additionalProperties);
        }
        return CompletableFuture.completedFuture(properties);
    }

    protected CompletableFuture<Map<String, String>> fillDeleteEventProperties(Activity activity, Map<String, String> additionalProperties) {
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put("recipientId", activity.getRecipient().getId());
        properties.put("conversationId", activity.getConversation().getId());
        properties.put("conversationName", activity.getConversation().getName());
        if (additionalProperties != null) {
            properties.putAll(additionalProperties);
        }
        return CompletableFuture.completedFuture(properties);
    }

    private void populateAdditionalChannelProperties(Activity activity, Map<String, String> properties) {
        ResultPair teamsChannelData;
        if (StringUtils.equalsIgnoreCase((CharSequence)activity.getChannelId(), (CharSequence)"msteams") && (teamsChannelData = activity.tryGetChannelData(TeamsChannelData.class)).result().booleanValue()) {
            if (((TeamsChannelData)teamsChannelData.value()).getTenant() != null) {
                properties.put("TeamsTenantId", ((TeamsChannelData)teamsChannelData.value()).getTenant().getId());
            }
            if (activity.getFrom() != null) {
                properties.put("TeamsUserAadObjectId", activity.getFrom().getAadObjectId());
            }
            try {
                if (((TeamsChannelData)teamsChannelData.value()).getTeam() != null) {
                    properties.put("TeamsTeamInfo", Serialization.toString((Object)((TeamsChannelData)teamsChannelData.value()).getTeam()));
                }
            }
            catch (JsonProcessingException jsonProcessingException) {
                // empty catch block
            }
        }
    }
}

