/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.bot.builder;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.TextNode;
import com.microsoft.bot.builder.Middleware;
import com.microsoft.bot.builder.NextDelegate;
import com.microsoft.bot.builder.TurnContext;
import com.microsoft.bot.schema.Activity;
import com.microsoft.bot.schema.Entity;
import java.util.concurrent.CompletableFuture;
import org.apache.commons.lang3.StringUtils;

public class SkypeMentionNormalizeMiddleware
implements Middleware {
    public static void normalizeSkypeMentionText(Activity activity) {
        if (StringUtils.equals((CharSequence)activity.getChannelId(), (CharSequence)"skype") && StringUtils.equals((CharSequence)activity.getType(), (CharSequence)"message")) {
            for (Entity entity : activity.getEntities()) {
                int openingBracket;
                String text;
                int closingBracket;
                if (!StringUtils.equals((CharSequence)entity.getType(), (CharSequence)"mention") || (closingBracket = (text = ((JsonNode)entity.getProperties().get("text")).asText()).indexOf(">")) == -1 || (openingBracket = text.indexOf("<", closingBracket)) == -1) continue;
                String mention = text.substring(closingBracket + 1, openingBracket).trim();
                TextNode node = JsonNodeFactory.instance.textNode(mention);
                entity.setProperties("text", (JsonNode)node);
            }
        }
    }

    @Override
    public CompletableFuture<Void> onTurn(TurnContext context, NextDelegate next) {
        SkypeMentionNormalizeMiddleware.normalizeSkypeMentionText(context.getActivity());
        return next.next();
    }
}

