/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.bot.builder;

import com.microsoft.bot.builder.Middleware;
import com.microsoft.bot.builder.NextDelegate;
import com.microsoft.bot.builder.TurnContext;
import com.microsoft.bot.connector.ExecutorFactory;
import com.microsoft.bot.connector.authentication.ClaimsIdentity;
import com.microsoft.bot.connector.authentication.SkillValidation;
import com.microsoft.bot.schema.Activity;
import com.microsoft.bot.schema.ConversationReference;
import com.microsoft.bot.schema.ResourceResponse;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.CompletableFuture;

public class ShowTypingMiddleware
implements Middleware {
    private static final int DEFAULT_DELAY = 500;
    private static final int DEFAULT_PERIOD = 2000;
    private long delay;
    private long period;

    public ShowTypingMiddleware() {
        this(500L, 2000L);
    }

    public ShowTypingMiddleware(long withDelay, long withPeriod) throws IllegalArgumentException {
        if (withDelay < 0L) {
            throw new IllegalArgumentException("Delay must be greater than or equal to zero");
        }
        if (withPeriod < 0L) {
            throw new IllegalArgumentException("Repeat period must be greater than zero");
        }
        this.delay = withDelay;
        this.period = withPeriod;
    }

    @Override
    public CompletableFuture<Void> onTurn(TurnContext turnContext, NextDelegate next) {
        if (!turnContext.getActivity().isType("message") || ShowTypingMiddleware.isSkillBot(turnContext).booleanValue()) {
            return next.next();
        }
        CompletableFuture<Void> sendFuture = ShowTypingMiddleware.sendTyping(turnContext, this.delay, this.period);
        return next.next().thenAccept(result -> sendFuture.cancel(true));
    }

    private static Boolean isSkillBot(TurnContext turnContext) {
        Object identity = turnContext.getTurnState().get("BotIdentity");
        if (identity instanceof ClaimsIdentity) {
            ClaimsIdentity claimsIdentity = (ClaimsIdentity)identity;
            return SkillValidation.isSkillClaim((Map)claimsIdentity.claims());
        }
        return false;
    }

    private static CompletableFuture<Void> sendTyping(TurnContext turnContext, long delay, long period) {
        return CompletableFuture.runAsync(() -> {
            try {
                Thread.sleep(delay);
                while (!Thread.currentThread().isInterrupted()) {
                    ShowTypingMiddleware.sendTypingActivity(turnContext).join();
                    Thread.sleep(period);
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }, ExecutorFactory.getExecutor());
    }

    private static CompletableFuture<ResourceResponse[]> sendTypingActivity(TurnContext turnContext) {
        Activity typingActivity = new Activity("typing");
        typingActivity.setRelatesTo(turnContext.getActivity().getRelatesTo());
        ConversationReference conversationReference = turnContext.getActivity().getConversationReference();
        typingActivity.applyConversationReference(conversationReference);
        return turnContext.getAdapter().sendActivities(turnContext, Collections.singletonList(typingActivity));
    }
}

