/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.bot.builder;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.JsonNode;
import com.microsoft.bot.builder.IntentScore;
import com.microsoft.bot.builder.RecognizerConvert;
import java.util.HashMap;
import java.util.Map;

public class RecognizerResult
implements RecognizerConvert {
    @JsonProperty(value="entities")
    private JsonNode entities;
    @JsonProperty(value="text")
    private String text;
    @JsonProperty(value="alteredText")
    private String alteredText;
    @JsonProperty(value="intents")
    private Map<String, IntentScore> intents;
    private HashMap<String, JsonNode> properties = new HashMap();

    @JsonIgnore
    public NamedIntentScore getTopScoringIntent() throws IllegalArgumentException {
        if (this.getIntents() == null) {
            throw new IllegalArgumentException("RecognizerResult.Intents cannot be null");
        }
        NamedIntentScore topIntent = new NamedIntentScore();
        for (Map.Entry<String, IntentScore> intent : this.getIntents().entrySet()) {
            double score = intent.getValue().getScore();
            if (!(score > topIntent.score)) continue;
            topIntent.intent = intent.getKey();
            topIntent.score = intent.getValue().getScore();
        }
        return topIntent;
    }

    public String getText() {
        return this.text;
    }

    public void setText(String withText) {
        this.text = withText;
    }

    public String getAlteredText() {
        return this.alteredText;
    }

    public void setAlteredText(String withAlteredText) {
        this.alteredText = withAlteredText;
    }

    public Map<String, IntentScore> getIntents() {
        return this.intents;
    }

    public void setIntents(Map<String, IntentScore> withIntents) {
        this.intents = withIntents;
    }

    public JsonNode getEntities() {
        return this.entities;
    }

    public void setEntities(JsonNode withEntities) {
        this.entities = withEntities;
    }

    @JsonAnyGetter
    public Map<String, JsonNode> getProperties() {
        return this.properties;
    }

    @JsonAnySetter
    public void setProperties(String key, JsonNode value) {
        this.properties.put(key, value);
    }

    @Override
    public void convert(Object result) {
        this.setText(((RecognizerResult)result).getText());
        this.setAlteredText(((RecognizerResult)result).getAlteredText());
        this.setIntents(((RecognizerResult)result).getIntents());
        this.setEntities(((RecognizerResult)result).getEntities());
        for (String key : ((RecognizerResult)result).getProperties().keySet()) {
            this.setProperties(key, ((RecognizerResult)result).getProperties().get(key));
        }
    }

    public static class NamedIntentScore {
        public String intent;
        public double score;
    }
}

