/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.bot.builder;

import com.microsoft.bot.builder.BotAssert;
import com.microsoft.bot.builder.BotCallbackHandler;
import com.microsoft.bot.builder.Middleware;
import com.microsoft.bot.builder.NextDelegate;
import com.microsoft.bot.builder.TurnContext;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;

public class MiddlewareSet
implements Middleware {
    private final List<Middleware> middlewareList = new ArrayList<Middleware>();

    public MiddlewareSet use(Middleware middleware) {
        BotAssert.middlewareNotNull(middleware);
        this.middlewareList.add(middleware);
        return this;
    }

    @Override
    public CompletableFuture<Void> onTurn(TurnContext turnContext, NextDelegate next) {
        return this.receiveActivityInternal(turnContext, null).thenCompose(result -> next.next());
    }

    public CompletableFuture<Void> receiveActivityWithStatus(TurnContext context, BotCallbackHandler callback) {
        return this.receiveActivityInternal(context, callback);
    }

    private CompletableFuture<Void> receiveActivityInternal(TurnContext context, BotCallbackHandler callback) {
        return this.receiveActivityInternal(context, callback, 0);
    }

    private CompletableFuture<Void> receiveActivityInternal(TurnContext context, BotCallbackHandler callback, int nextMiddlewareIndex) {
        if (nextMiddlewareIndex == this.middlewareList.size()) {
            if (callback == null) {
                return CompletableFuture.completedFuture(null);
            }
            return callback.invoke(context);
        }
        Middleware nextMiddleware = this.middlewareList.get(nextMiddlewareIndex);
        return nextMiddleware.onTurn(context, () -> this.receiveActivityInternal(context, callback, nextMiddlewareIndex + 1));
    }
}

