/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.bingads.bulk.entities;

import com.microsoft.bingads.InternalException;
import com.microsoft.bingads.bulk.entities.BulkEntity;
import com.microsoft.bingads.bulk.entities.BulkTargetBid;
import com.microsoft.bingads.bulk.entities.BulkTargetIdentifier;
import com.microsoft.bingads.bulk.entities.Status;
import com.microsoft.bingads.internal.bulk.BulkObjectWriter;
import com.microsoft.bingads.internal.bulk.entities.MultiRecordBulkEntity;
import com.microsoft.bingads.internal.functionalinterfaces.Consumer;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

abstract class BulkSubTarget<TBid extends BulkTargetBid>
extends MultiRecordBulkEntity {
    private Status status;
    private Long targetId;
    private Long entityId;
    private String entityName;
    private String parentEntityName;
    private boolean hasDeleteAllRow;
    private final List<TBid> bids = new ArrayList<TBid>();
    private final Class<TBid> classOfTBid;
    boolean isBeingWrittenAsPartOfParentTarget;

    public BulkSubTarget(Class<TBid> classOfTBid) {
        this.classOfTBid = classOfTBid;
    }

    public List<TBid> getBids() {
        return Collections.unmodifiableList(this.bids);
    }

    void setBids(List<TBid> bids) {
        for (BulkTargetBid bid : bids) {
            this.bids.add(bid);
        }
        this.reconstructSubTargets();
        this.setStatus(bids.size() > 0 ? Status.ACTIVE : Status.DELETED);
    }

    void setIdentifier(BulkTargetIdentifier identifier) {
        if (identifier.getTargetBidType() != this.classOfTBid) {
            throw new InternalException(new IllegalArgumentException("Invalid identifier type"));
        }
        this.hasDeleteAllRow = identifier.isDeleteRow();
        this.setEntityId(identifier.getEntityId());
        this.setTargetId(identifier.getTargetId());
        this.setEntityName(identifier.getEntityName());
        this.setParentEntityName(identifier.getParentEntityName());
    }

    @Override
    public void writeToStream(BulkObjectWriter rowWriter, boolean excludeReadonlyData) throws IOException {
        if (!this.isBeingWrittenAsPartOfParentTarget && this.getStatus() != Status.DELETED) {
            this.validatePropertiesNotNull();
        }
        this.validateBidsNotNullOrEmpty();
        BulkTargetIdentifier identifier = ((BulkTargetBid)this.createBid()).getIdentifier();
        identifier.setStatus(Status.DELETED);
        identifier.setTargetId(this.getTargetId());
        identifier.setEntityId(this.getEntityId());
        identifier.setEntityName(this.getEntityName());
        identifier.setParentEntityName(this.getParentEntityName());
        identifier.writeToStream(rowWriter, excludeReadonlyData);
        if (this.getStatus() == Status.DELETED) {
            return;
        }
        for (BulkTargetBid bid : this.convertApiToBulkBids()) {
            bid.writeToStream(rowWriter, excludeReadonlyData);
        }
    }

    abstract void reconstructSubTargets();

    void validatePropertiesNotNull() {
    }

    void validateBidsNotNullOrEmpty() {
    }

    abstract TBid createBid();

    abstract List<TBid> convertApiToBulkBids();

    TBid createAndPopulateBid(Consumer<TBid> setAdditionalProperties) {
        TBid bid = this.createBid();
        ((BulkTargetBid)bid).setStatus(this.getStatus());
        ((BulkTargetBid)bid).setTargetId(this.getTargetId());
        ((BulkTargetBid)bid).setEntityId(this.getEntityId());
        ((BulkTargetBid)bid).setEntityName(this.getEntityName());
        ((BulkTargetBid)bid).setParentEntityName(this.getParentEntityName());
        setAdditionalProperties.accept(bid);
        return bid;
    }

    @Override
    public List<? extends BulkEntity> getChildEntities() {
        return this.getBids();
    }

    @Override
    public boolean allChildrenPresent() {
        return this.hasDeleteAllRow;
    }

    public Status getStatus() {
        return this.status;
    }

    public void setStatus(Status status) {
        this.status = status;
    }

    public Long getTargetId() {
        return this.targetId;
    }

    public void setTargetId(Long targetId) {
        this.targetId = targetId;
    }

    Long getEntityId() {
        return this.entityId;
    }

    void setEntityId(Long entityId) {
        this.entityId = entityId;
    }

    String getEntityName() {
        return this.entityName;
    }

    void setEntityName(String entityName) {
        this.entityName = entityName;
    }

    String getParentEntityName() {
        return this.parentEntityName;
    }

    void setParentEntityName(String parentEntityName) {
        this.parentEntityName = parentEntityName;
    }
}

