/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.storage.table;

import com.microsoft.azure.storage.DoesServiceRequest;
import com.microsoft.azure.storage.IPRange;
import com.microsoft.azure.storage.OperationContext;
import com.microsoft.azure.storage.RequestOptions;
import com.microsoft.azure.storage.ResultContinuation;
import com.microsoft.azure.storage.ResultSegment;
import com.microsoft.azure.storage.SharedAccessPolicyHandler;
import com.microsoft.azure.storage.SharedAccessPolicySerializer;
import com.microsoft.azure.storage.SharedAccessProtocols;
import com.microsoft.azure.storage.StorageCredentials;
import com.microsoft.azure.storage.StorageCredentialsSharedAccessSignature;
import com.microsoft.azure.storage.StorageException;
import com.microsoft.azure.storage.StorageExtendedErrorInformation;
import com.microsoft.azure.storage.StorageUri;
import com.microsoft.azure.storage.core.ExecutionEngine;
import com.microsoft.azure.storage.core.PathUtility;
import com.microsoft.azure.storage.core.RequestLocationMode;
import com.microsoft.azure.storage.core.SharedAccessSignatureHelper;
import com.microsoft.azure.storage.core.StorageCredentialsHelper;
import com.microsoft.azure.storage.core.StorageRequest;
import com.microsoft.azure.storage.core.UriQueryBuilder;
import com.microsoft.azure.storage.core.Utility;
import com.microsoft.azure.storage.table.CloudTableClient;
import com.microsoft.azure.storage.table.DynamicTableEntity;
import com.microsoft.azure.storage.table.EntityProperty;
import com.microsoft.azure.storage.table.EntityResolver;
import com.microsoft.azure.storage.table.QueryTableOperation;
import com.microsoft.azure.storage.table.SharedAccessTablePolicy;
import com.microsoft.azure.storage.table.TableBatchOperation;
import com.microsoft.azure.storage.table.TableEntity;
import com.microsoft.azure.storage.table.TableOperation;
import com.microsoft.azure.storage.table.TableOperationType;
import com.microsoft.azure.storage.table.TablePermissions;
import com.microsoft.azure.storage.table.TableQuery;
import com.microsoft.azure.storage.table.TableRequest;
import com.microsoft.azure.storage.table.TableRequestOptions;
import com.microsoft.azure.storage.table.TableResult;
import com.microsoft.azure.storage.table.TableStorageErrorDeserializer;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.StringWriter;
import java.net.HttpURLConnection;
import java.net.URI;
import java.net.URISyntaxException;
import java.security.InvalidKeyException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Locale;

public final class CloudTable {
    private String name;
    private StorageUri storageUri;
    private CloudTableClient tableServiceClient;

    public String getName() {
        return this.name;
    }

    public CloudTableClient getServiceClient() {
        return this.tableServiceClient;
    }

    public final StorageUri getStorageUri() {
        return this.storageUri;
    }

    public URI getUri() {
        return this.storageUri.getPrimaryUri();
    }

    public CloudTable(URI uri) throws StorageException {
        this(new StorageUri(uri, null));
    }

    public CloudTable(StorageUri uri) throws StorageException {
        this(uri, (StorageCredentials)null);
    }

    public CloudTable(URI uri, StorageCredentials credentials) throws StorageException {
        this(new StorageUri(uri, null), credentials);
    }

    public CloudTable(StorageUri uri, StorageCredentials credentials) throws StorageException {
        this.parseQueryAndVerify(uri, credentials);
    }

    protected CloudTable(String tableName, CloudTableClient client) throws URISyntaxException, StorageException {
        Utility.assertNotNull("client", client);
        Utility.assertNotNull("tableName", tableName);
        this.storageUri = PathUtility.appendPathToUri(client.getStorageUri(), tableName);
        this.name = tableName;
        this.tableServiceClient = client;
    }

    @DoesServiceRequest
    public void create() throws StorageException {
        this.create(null, null);
    }

    @DoesServiceRequest
    public void create(TableRequestOptions options, OperationContext opContext) throws StorageException {
        if (opContext == null) {
            opContext = new OperationContext();
        }
        opContext.initialize();
        options = TableRequestOptions.populateAndApplyDefaults(options, this.tableServiceClient);
        Utility.assertNotNullOrEmpty("tableName", this.name);
        DynamicTableEntity tableEntry = new DynamicTableEntity();
        tableEntry.getProperties().put("TableName", new EntityProperty(this.name));
        TableOperation.insert(tableEntry).execute(this.tableServiceClient, "Tables", options, opContext);
    }

    @DoesServiceRequest
    public boolean createIfNotExists() throws StorageException {
        return this.createIfNotExists(null, null);
    }

    @DoesServiceRequest
    public boolean createIfNotExists(TableRequestOptions options, OperationContext opContext) throws StorageException {
        boolean exists = this.exists(true, options = TableRequestOptions.populateAndApplyDefaults(options, this.tableServiceClient), opContext);
        if (exists) {
            return false;
        }
        try {
            this.create(options, opContext);
            return true;
        }
        catch (StorageException e) {
            if (e.getHttpStatusCode() == 409 && "TableAlreadyExists".equals(e.getErrorCode())) {
                return false;
            }
            throw e;
        }
    }

    @DoesServiceRequest
    public void delete() throws StorageException {
        this.delete(null, null);
    }

    @DoesServiceRequest
    public void delete(TableRequestOptions options, OperationContext opContext) throws StorageException {
        if (opContext == null) {
            opContext = new OperationContext();
        }
        opContext.initialize();
        options = TableRequestOptions.populateAndApplyDefaults(options, this.tableServiceClient);
        Utility.assertNotNullOrEmpty("tableName", this.name);
        DynamicTableEntity tableEntry = new DynamicTableEntity();
        tableEntry.getProperties().put("TableName", new EntityProperty(this.name));
        TableOperation deleteOp = new TableOperation(tableEntry, TableOperationType.DELETE);
        deleteOp.execute(this.tableServiceClient, "Tables", options, opContext);
    }

    @DoesServiceRequest
    public boolean deleteIfExists() throws StorageException {
        return this.deleteIfExists(null, null);
    }

    @DoesServiceRequest
    public boolean deleteIfExists(TableRequestOptions options, OperationContext opContext) throws StorageException {
        if (this.exists(true, options = TableRequestOptions.populateAndApplyDefaults(options, this.tableServiceClient), opContext)) {
            try {
                this.delete(options, opContext);
            }
            catch (StorageException ex) {
                if (ex.getHttpStatusCode() == 404 && "ResourceNotFound".equals(ex.getErrorCode())) {
                    return false;
                }
                throw ex;
            }
            return true;
        }
        return false;
    }

    @DoesServiceRequest
    public ArrayList<TableResult> execute(TableBatchOperation batch) throws StorageException {
        return this.execute(batch, null, null);
    }

    @DoesServiceRequest
    public ArrayList<TableResult> execute(TableBatchOperation batch, TableRequestOptions options, OperationContext opContext) throws StorageException {
        Utility.assertNotNull("batch", batch);
        if (opContext == null) {
            opContext = new OperationContext();
        }
        opContext.initialize();
        options = TableRequestOptions.populateAndApplyDefaults(options, this.getServiceClient());
        return batch.execute(this.getServiceClient(), this.getName(), options, opContext);
    }

    @DoesServiceRequest
    public TableResult execute(TableOperation operation) throws StorageException {
        return this.execute(operation, null, null);
    }

    @DoesServiceRequest
    public TableResult execute(TableOperation operation, TableRequestOptions options, OperationContext opContext) throws StorageException {
        Utility.assertNotNull("operation", operation);
        return operation.execute(this.getServiceClient(), this.getName(), options, opContext);
    }

    @DoesServiceRequest
    public <R> Iterable<R> execute(TableQuery<?> query, EntityResolver<R> resolver) {
        return this.execute(query, resolver, null, null);
    }

    @DoesServiceRequest
    public <R> Iterable<R> execute(TableQuery<?> query, EntityResolver<R> resolver, TableRequestOptions options, OperationContext opContext) {
        Utility.assertNotNull("query", query);
        Utility.assertNotNull("Query requires a valid class type or resolver.", resolver);
        query.setSourceTableName(this.getName());
        return this.getServiceClient().generateIteratorForQuery(query, resolver, options, opContext);
    }

    @DoesServiceRequest
    public <T extends TableEntity> Iterable<T> execute(TableQuery<T> query) {
        return this.execute(query, null, null);
    }

    @DoesServiceRequest
    public <T extends TableEntity> Iterable<T> execute(TableQuery<T> query, TableRequestOptions options, OperationContext opContext) {
        Utility.assertNotNull("query", query);
        Utility.assertNotNull("Query requires a valid class type or resolver.", query.getClazzType());
        query.setSourceTableName(this.getName());
        return this.getServiceClient().generateIteratorForQuery(query, null, options, opContext);
    }

    @DoesServiceRequest
    public <R> ResultSegment<R> executeSegmented(TableQuery<?> query, EntityResolver<R> resolver, ResultContinuation continuationToken) throws StorageException {
        return this.executeSegmented(query, resolver, continuationToken, null, null);
    }

    @DoesServiceRequest
    public <R> ResultSegment<R> executeSegmented(TableQuery<?> query, EntityResolver<R> resolver, ResultContinuation continuationToken, TableRequestOptions options, OperationContext opContext) throws StorageException {
        Utility.assertNotNull("Query requires a valid class type or resolver.", resolver);
        query.setSourceTableName(this.getName());
        return this.getServiceClient().executeQuerySegmentedImpl(query, resolver, continuationToken, options, opContext);
    }

    @DoesServiceRequest
    public <T extends TableEntity> ResultSegment<T> executeSegmented(TableQuery<T> query, ResultContinuation continuationToken) throws StorageException {
        return this.executeSegmented(query, continuationToken, null, null);
    }

    @DoesServiceRequest
    public <T extends TableEntity> ResultSegment<T> executeSegmented(TableQuery<T> query, ResultContinuation continuationToken, TableRequestOptions options, OperationContext opContext) throws StorageException {
        Utility.assertNotNull("query", query);
        query.setSourceTableName(this.getName());
        return this.getServiceClient().executeQuerySegmentedImpl(query, null, continuationToken, options, opContext);
    }

    @DoesServiceRequest
    public boolean exists() throws StorageException {
        return this.exists(null, null);
    }

    @DoesServiceRequest
    public boolean exists(TableRequestOptions options, OperationContext opContext) throws StorageException {
        return this.exists(false, options, opContext);
    }

    @DoesServiceRequest
    private boolean exists(boolean primaryOnly, TableRequestOptions options, OperationContext opContext) throws StorageException {
        if (opContext == null) {
            opContext = new OperationContext();
        }
        opContext.initialize();
        options = TableRequestOptions.populateAndApplyDefaults(options, this.tableServiceClient);
        Utility.assertNotNullOrEmpty("tableName", this.name);
        QueryTableOperation operation = (QueryTableOperation)TableOperation.retrieve(this.name, null, DynamicTableEntity.class);
        operation.setPrimaryOnlyRetrieve(primaryOnly);
        TableResult result = operation.execute(this.tableServiceClient, "Tables", options, opContext);
        if (result.getHttpStatusCode() == 200) {
            return true;
        }
        if (result.getHttpStatusCode() == 404) {
            return false;
        }
        throw new StorageException("OutOfRangeInput", "Unexpected http status code received.", result.getHttpStatusCode(), null, null);
    }

    @DoesServiceRequest
    public void uploadPermissions(TablePermissions permissions) throws StorageException {
        this.uploadPermissions(permissions, null, null);
    }

    @DoesServiceRequest
    public void uploadPermissions(TablePermissions permissions, TableRequestOptions options, OperationContext opContext) throws StorageException {
        if (opContext == null) {
            opContext = new OperationContext();
        }
        opContext.initialize();
        options = TableRequestOptions.populateAndApplyDefaults(options, this.tableServiceClient);
        ExecutionEngine.executeWithRetry(this.tableServiceClient, this, this.uploadPermissionsImpl(permissions, options), options.getRetryPolicyFactory(), opContext);
    }

    private StorageRequest<CloudTableClient, CloudTable, Void> uploadPermissionsImpl(TablePermissions permissions, final TableRequestOptions options) throws StorageException {
        StringWriter outBuffer = new StringWriter();
        try {
            SharedAccessPolicySerializer.writeSharedAccessIdentifiersToStream(permissions.getSharedAccessPolicies(), outBuffer);
            final byte[] aclBytes = outBuffer.toString().getBytes("UTF-8");
            StorageRequest<CloudTableClient, CloudTable, Void> putRequest = new StorageRequest<CloudTableClient, CloudTable, Void>((RequestOptions)options, this.getStorageUri()){

                @Override
                public HttpURLConnection buildRequest(CloudTableClient client, CloudTable table, OperationContext context) throws Exception {
                    this.setSendStream(new ByteArrayInputStream(aclBytes));
                    this.setLength(Long.valueOf(aclBytes.length));
                    return TableRequest.setAcl(table.getStorageUri().getUri(this.getCurrentLocation()), options, context);
                }

                @Override
                public void signRequest(HttpURLConnection connection, CloudTableClient client, OperationContext context) throws Exception {
                    StorageRequest.signTableRequest(connection, client, aclBytes.length, context);
                }

                @Override
                public Void preProcessResponse(CloudTable parentObject, CloudTableClient client, OperationContext context) throws Exception {
                    if (this.getResult().getStatusCode() != 204) {
                        this.setNonExceptionedRetryableFailure(true);
                    }
                    return null;
                }

                @Override
                public StorageExtendedErrorInformation parseErrorDetails() {
                    return TableStorageErrorDeserializer.parseErrorDetails(this);
                }
            };
            return putRequest;
        }
        catch (IllegalArgumentException e) {
            StorageException translatedException = StorageException.translateClientException(e);
            throw translatedException;
        }
        catch (IllegalStateException e) {
            StorageException translatedException = StorageException.translateClientException(e);
            throw translatedException;
        }
        catch (IOException e) {
            StorageException translatedException = StorageException.translateClientException(e);
            throw translatedException;
        }
    }

    @DoesServiceRequest
    public TablePermissions downloadPermissions() throws StorageException {
        return this.downloadPermissions(null, null);
    }

    @DoesServiceRequest
    public TablePermissions downloadPermissions(TableRequestOptions options, OperationContext opContext) throws StorageException {
        if (opContext == null) {
            opContext = new OperationContext();
        }
        opContext.initialize();
        options = TableRequestOptions.populateAndApplyDefaults(options, this.tableServiceClient);
        return ExecutionEngine.executeWithRetry(this.tableServiceClient, this, this.downloadPermissionsImpl(options), options.getRetryPolicyFactory(), opContext);
    }

    private StorageRequest<CloudTableClient, CloudTable, TablePermissions> downloadPermissionsImpl(final TableRequestOptions options) {
        StorageRequest<CloudTableClient, CloudTable, TablePermissions> getRequest = new StorageRequest<CloudTableClient, CloudTable, TablePermissions>((RequestOptions)options, this.getStorageUri()){

            @Override
            public void setRequestLocationMode() {
                this.setRequestLocationMode(RequestLocationMode.PRIMARY_OR_SECONDARY);
            }

            @Override
            public HttpURLConnection buildRequest(CloudTableClient client, CloudTable table, OperationContext context) throws Exception {
                return TableRequest.getAcl(table.getStorageUri().getUri(this.getCurrentLocation()), options, context);
            }

            @Override
            public void signRequest(HttpURLConnection connection, CloudTableClient client, OperationContext context) throws Exception {
                StorageRequest.signTableRequest(connection, client, -1L, context);
            }

            @Override
            public TablePermissions preProcessResponse(CloudTable parentObject, CloudTableClient client, OperationContext context) throws Exception {
                if (this.getResult().getStatusCode() != 200) {
                    this.setNonExceptionedRetryableFailure(true);
                }
                return new TablePermissions();
            }

            @Override
            public TablePermissions postProcessResponse(HttpURLConnection connection, CloudTable table, CloudTableClient client, OperationContext context, TablePermissions permissions) throws Exception {
                HashMap<String, SharedAccessTablePolicy> accessIds = SharedAccessPolicyHandler.getAccessIdentifiers(this.getConnection().getInputStream(), SharedAccessTablePolicy.class);
                for (String key : accessIds.keySet()) {
                    permissions.getSharedAccessPolicies().put(key, accessIds.get(key));
                }
                return permissions;
            }

            @Override
            public StorageExtendedErrorInformation parseErrorDetails() {
                return TableStorageErrorDeserializer.parseErrorDetails(this);
            }
        };
        return getRequest;
    }

    public String generateSharedAccessSignature(SharedAccessTablePolicy policy, String accessPolicyIdentifier, String startPartitionKey, String startRowKey, String endPartitionKey, String endRowKey) throws InvalidKeyException, StorageException {
        return this.generateSharedAccessSignature(policy, accessPolicyIdentifier, startPartitionKey, startRowKey, endPartitionKey, endRowKey, null, null);
    }

    public String generateSharedAccessSignature(SharedAccessTablePolicy policy, String accessPolicyIdentifier, String startPartitionKey, String startRowKey, String endPartitionKey, String endRowKey, IPRange ipRange, SharedAccessProtocols protocols) throws InvalidKeyException, StorageException {
        if (!StorageCredentialsHelper.canCredentialsSignRequest(this.tableServiceClient.getCredentials())) {
            throw new IllegalArgumentException("Cannot create Shared Access Signature unless the Account Key credentials are used by the ServiceClient.");
        }
        String resourceName = this.getSharedAccessCanonicalName();
        String signature = SharedAccessSignatureHelper.generateSharedAccessSignatureHashForTable(policy, accessPolicyIdentifier, resourceName, ipRange, protocols, startPartitionKey, startRowKey, endPartitionKey, endRowKey, this.tableServiceClient);
        UriQueryBuilder builder = SharedAccessSignatureHelper.generateSharedAccessSignatureForTable(policy, startPartitionKey, startRowKey, endPartitionKey, endRowKey, accessPolicyIdentifier, ipRange, protocols, this.name, signature);
        return builder.toString();
    }

    private String getSharedAccessCanonicalName() {
        String accountName = this.getServiceClient().getCredentials().getAccountName();
        String tableNameLowerCase = this.getName().toLowerCase(Locale.ENGLISH);
        return String.format("/%s/%s/%s", "table", accountName, tableNameLowerCase);
    }

    private void parseQueryAndVerify(StorageUri completeUri, StorageCredentials credentials) throws StorageException {
        Utility.assertNotNull("completeUri", completeUri);
        if (!completeUri.isAbsolute()) {
            throw new IllegalArgumentException(String.format("Address %s is a relative address. Only absolute addresses are permitted.", completeUri.toString()));
        }
        this.storageUri = PathUtility.stripURIQueryAndFragment(completeUri);
        StorageCredentialsSharedAccessSignature parsedCredentials = SharedAccessSignatureHelper.parseQuery(completeUri);
        if (credentials != null && parsedCredentials != null) {
            throw new IllegalArgumentException("Cannot provide credentials as part of the address and as constructor parameter. Either pass in the address or use a different constructor.");
        }
        try {
            boolean usePathStyleUris = Utility.determinePathStyleFromUri(this.storageUri.getPrimaryUri());
            this.tableServiceClient = new CloudTableClient(PathUtility.getServiceClientBaseAddress(this.getStorageUri(), usePathStyleUris), credentials != null ? credentials : parsedCredentials);
            this.name = PathUtility.getTableNameFromUri(this.storageUri.getPrimaryUri(), usePathStyleUris);
        }
        catch (URISyntaxException e) {
            throw Utility.generateNewUnexpectedStorageException(e);
        }
    }
}

