/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.appcenter.reactnative.shared;

import android.app.Application;
import android.text.TextUtils;
import com.microsoft.appcenter.AppCenter;
import com.microsoft.appcenter.ingestion.models.WrapperSdk;
import com.microsoft.appcenter.utils.AppCenterLog;
import java.io.InputStream;
import org.json.JSONObject;

public class AppCenterReactNativeShared {
    private static final String APPCENTER_CONFIG_ASSET = "appcenter-config.json";
    private static final String APP_SECRET_KEY = "app_secret";
    private static final String START_AUTOMATICALLY_KEY = "start_automatically";
    private static Application sApplication;
    private static String sAppSecret;
    private static boolean sStartAutomatically;

    public static synchronized void configureAppCenter(Application application) {
        if (sApplication != null) {
            return;
        }
        sApplication = application;
        WrapperSdk wrapperSdk = new WrapperSdk();
        wrapperSdk.setWrapperSdkVersion("1.8.1");
        wrapperSdk.setWrapperSdkName("appcenter.react-native");
        AppCenter.setWrapperSdk((WrapperSdk)wrapperSdk);
        AppCenterReactNativeShared.readConfigurationFile();
        if (!sStartAutomatically) {
            AppCenterLog.debug((String)"AppCenter", (String)"Configure not to start automatically.");
            return;
        }
        if (TextUtils.isEmpty((CharSequence)sAppSecret)) {
            AppCenterLog.debug((String)"AppCenter", (String)"Configure without secret.");
            AppCenter.configure((Application)application);
        } else {
            AppCenterLog.debug((String)"AppCenter", (String)"Configure with secret.");
            AppCenter.configure((Application)application, (String)sAppSecret);
        }
    }

    private static void readConfigurationFile() {
        if (sAppSecret == null) {
            try {
                AppCenterLog.debug((String)"AppCenter", (String)"Reading appcenter-config.json");
                InputStream configStream = sApplication.getAssets().open(APPCENTER_CONFIG_ASSET);
                int size = configStream.available();
                byte[] buffer = new byte[size];
                configStream.read(buffer);
                configStream.close();
                String jsonContents = new String(buffer, "UTF-8");
                JSONObject json = new JSONObject(jsonContents);
                sAppSecret = json.optString(APP_SECRET_KEY);
                sStartAutomatically = json.optBoolean(START_AUTOMATICALLY_KEY, true);
            }
            catch (Exception e) {
                AppCenterLog.error((String)"AppCenter", (String)"Failed to parse appcenter-config.json", (Throwable)e);
            }
        }
    }

    public static synchronized void setAppSecret(String secret) {
        sAppSecret = secret;
    }

    public static synchronized void setStartAutomatically(boolean startAutomatically) {
        sStartAutomatically = startAutomatically;
    }
}

