/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.appcenter.reactnative.shared;

import android.app.Application;
import android.text.TextUtils;
import com.microsoft.appcenter.AppCenter;
import com.microsoft.appcenter.ingestion.models.WrapperSdk;
import com.microsoft.appcenter.utils.AppCenterLog;
import java.io.InputStream;
import org.json.JSONObject;

public class AppCenterReactNativeShared {
    private static final String APP_SECRET_KEY = "app_secret";
    private static final String START_AUTOMATICALLY_KEY = "start_automatically";
    private static String sAppSecret;
    private static boolean sStartAutomatically;
    private static Application sApplication;
    private static WrapperSdk sWrapperSdk;

    public static void configureAppCenter(Application application) {
        if (sApplication != null) {
            return;
        }
        sApplication = application;
        sWrapperSdk.setWrapperSdkVersion("1.8.0");
        sWrapperSdk.setWrapperSdkName("appcenter.react-native");
        AppCenter.setWrapperSdk((WrapperSdk)sWrapperSdk);
        if (!sStartAutomatically) {
            return;
        }
        String appSecret = AppCenterReactNativeShared.getAppSecret();
        if (TextUtils.isEmpty((CharSequence)appSecret)) {
            AppCenterLog.debug((String)"AppCenter", (String)"Configure without secret");
            AppCenter.configure((Application)application);
        } else {
            AppCenterLog.debug((String)"AppCenter", (String)"Configure with secret");
            AppCenter.configure((Application)application, (String)appSecret);
        }
    }

    public static void setWrapperSdk(WrapperSdk wrapperSdk) {
        sWrapperSdk = wrapperSdk;
        AppCenter.setWrapperSdk((WrapperSdk)wrapperSdk);
    }

    public static WrapperSdk getWrapperSdk() {
        return sWrapperSdk;
    }

    public static void setAppSecret(String secret) {
        sAppSecret = secret;
    }

    public static String getAppSecret() {
        if (sAppSecret == null) {
            try {
                InputStream configStream = sApplication.getAssets().open("appcenter-config.json");
                int size = configStream.available();
                byte[] buffer = new byte[size];
                configStream.read(buffer);
                configStream.close();
                String jsonContents = new String(buffer, "UTF-8");
                JSONObject json = new JSONObject(jsonContents);
                sAppSecret = json.getString(APP_SECRET_KEY);
                sStartAutomatically = json.optBoolean(START_AUTOMATICALLY_KEY, true);
            }
            catch (Exception e) {
                AppCenterLog.error((String)"AppCenter", (String)"Failed to parse appcenter-config.json", (Throwable)e);
            }
        }
        return sAppSecret;
    }

    public static void setStartAutomatically(boolean startAutomatically) {
        sStartAutomatically = startAutomatically;
    }

    static {
        sWrapperSdk = new WrapperSdk();
    }
}

