/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.appcenter.analytics;

import com.microsoft.appcenter.ingestion.models.properties.BooleanTypedProperty;
import com.microsoft.appcenter.ingestion.models.properties.DateTimeTypedProperty;
import com.microsoft.appcenter.ingestion.models.properties.DoubleTypedProperty;
import com.microsoft.appcenter.ingestion.models.properties.LongTypedProperty;
import com.microsoft.appcenter.ingestion.models.properties.StringTypedProperty;
import com.microsoft.appcenter.ingestion.models.properties.TypedProperty;
import com.microsoft.appcenter.utils.AppCenterLog;
import java.util.Date;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class EventProperties {
    private static final String VALUE_NULL_ERROR_MESSAGE = "Property value cannot be null";
    private final Map<String, TypedProperty> mProperties = new ConcurrentHashMap<String, TypedProperty>();

    Map<String, TypedProperty> getProperties() {
        return this.mProperties;
    }

    public EventProperties set(String key, boolean value) {
        if (this.isValidKey(key)) {
            BooleanTypedProperty property = new BooleanTypedProperty();
            property.setName(key);
            property.setValue(value);
            this.mProperties.put(key, (TypedProperty)property);
        }
        return this;
    }

    public EventProperties set(String key, Date value) {
        if (this.isValidKey(key) && this.isValidValue(value)) {
            DateTimeTypedProperty property = new DateTimeTypedProperty();
            property.setName(key);
            property.setValue(value);
            this.mProperties.put(key, (TypedProperty)property);
        }
        return this;
    }

    public EventProperties set(String key, double value) {
        if (this.isValidKey(key)) {
            if (Double.isInfinite(value) || Double.isNaN(value)) {
                AppCenterLog.error((String)"AppCenterAnalytics", (String)"Double property value cannot be NaN or infinite.");
            } else {
                DoubleTypedProperty property = new DoubleTypedProperty();
                property.setName(key);
                property.setValue(value);
                this.mProperties.put(key, (TypedProperty)property);
            }
        }
        return this;
    }

    public EventProperties set(String key, long value) {
        if (this.isValidKey(key)) {
            LongTypedProperty property = new LongTypedProperty();
            property.setName(key);
            property.setValue(value);
            this.mProperties.put(key, (TypedProperty)property);
        }
        return this;
    }

    public EventProperties set(String key, String value) {
        if (this.isValidKey(key) && this.isValidValue(value)) {
            StringTypedProperty property = new StringTypedProperty();
            property.setName(key);
            property.setValue(value);
            this.mProperties.put(key, (TypedProperty)property);
        }
        return this;
    }

    private boolean isValidKey(String key) {
        if (key == null) {
            AppCenterLog.error((String)"AppCenterAnalytics", (String)"Property key must not be null");
            return false;
        }
        if (this.mProperties.containsKey(key)) {
            AppCenterLog.warn((String)"AppCenterAnalytics", (String)("Property \"" + key + "\" is already set and will be overridden."));
        }
        return true;
    }

    private boolean isValidValue(Object value) {
        if (value == null) {
            AppCenterLog.error((String)"AppCenterAnalytics", (String)VALUE_NULL_ERROR_MESSAGE);
            return false;
        }
        return true;
    }
}

