/*
 * Decompiled with CFR 0.152.
 */
package com.mi.xserv;

import android.content.ContentResolver;
import android.content.Context;
import android.os.Handler;
import android.os.Looper;
import android.provider.Settings;
import com.koushikdutta.async.http.AsyncHttpClient;
import com.mi.xserv.R;
import com.mi.xserv.Xserv;
import java.io.IOException;
import java.io.InputStream;
import java.lang.ref.WeakReference;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;
import java.util.UUID;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManagerFactory;
import org.json.JSONObject;

public class XservBase {
    private final Handler mHandler = new Handler(Looper.getMainLooper());
    private WeakReference<Xserv.OnXservEventListener> mDelegate = new WeakReference<Object>(null);
    private TrustManagerFactory mTmf;
    private SSLContext mSSLContext;

    public void setOnEventListener(Xserv.OnXservEventListener onEventListener) {
        this.mDelegate = new WeakReference<Xserv.OnXservEventListener>(onEventListener);
    }

    protected Handler getMainLooper() {
        return this.mHandler;
    }

    private void fixAuthority() {
        Xserv.OnXservEventListener delegate = (Xserv.OnXservEventListener)this.mDelegate.get();
        if (delegate != null && (this.mTmf == null || this.mSSLContext == null)) {
            try {
                CertificateFactory cf = CertificateFactory.getInstance("X.509");
                InputStream caInput = ((Context)delegate).getResources().openRawResource(R.raw.lets_encrypt_x1_cross_signed_pem);
                Certificate ca = cf.generateCertificate(caInput);
                caInput.close();
                String keyStoreType = KeyStore.getDefaultType();
                KeyStore keyStore = KeyStore.getInstance(keyStoreType);
                keyStore.load(null, null);
                keyStore.setCertificateEntry("ca", ca);
                String tmfAlgorithm = TrustManagerFactory.getDefaultAlgorithm();
                this.mTmf = TrustManagerFactory.getInstance(tmfAlgorithm);
                this.mTmf.init(keyStore);
                this.mSSLContext = SSLContext.getInstance("TLS");
                this.mSSLContext.init(null, this.mTmf.getTrustManagers(), null);
            }
            catch (IOException | KeyManagementException | KeyStoreException | NoSuchAlgorithmException | CertificateException e) {
                e.printStackTrace();
            }
        }
    }

    protected AsyncHttpClient getWebSocketClient(boolean securiry) {
        AsyncHttpClient as = AsyncHttpClient.getDefaultInstance();
        if (securiry) {
            this.fixAuthority();
            if (this.mTmf != null && this.mSSLContext != null) {
                as.getSSLSocketMiddleware().setTrustManagers(this.mTmf.getTrustManagers());
                as.getSSLSocketMiddleware().setSSLContext(this.mSSLContext);
            }
        }
        return as;
    }

    protected AsyncHttpClient getHttpClient(String url) {
        AsyncHttpClient as = AsyncHttpClient.getDefaultInstance();
        if (url.startsWith("https://mobile-italia.com")) {
            this.fixAuthority();
            if (this.mTmf != null && this.mSSLContext != null) {
                as.getSSLSocketMiddleware().setTrustManagers(this.mTmf.getTrustManagers());
                as.getSSLSocketMiddleware().setSSLContext(this.mSSLContext);
            }
        }
        return as;
    }

    protected String getDeviceID() {
        Xserv.OnXservEventListener delegate = (Xserv.OnXservEventListener)this.mDelegate.get();
        String deviceID = null;
        if (delegate != null) {
            try {
                deviceID = Settings.Secure.getString((ContentResolver)((Context)delegate).getContentResolver(), (String)"android_id");
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (deviceID == null) {
            deviceID = UUID.randomUUID().toString();
        }
        return deviceID;
    }

    protected String getLanguage() {
        return Locale.getDefault().toString().replace("_", "-");
    }

    protected int getTimeZoneOffset() {
        TimeZone timezone = TimeZone.getDefault();
        int seconds = timezone.getOffset(15L) / 1000;
        double minutes = seconds / 60;
        double hours = minutes / 60.0;
        return (int)hours;
    }

    protected int getTimeZoneDst() {
        Date today = new Date();
        TimeZone timezone = TimeZone.getDefault();
        boolean isDST = timezone.inDaylightTime(today);
        return isDST ? 1 : 0;
    }

    protected void onOpenConnection() {
        final Xserv.OnXservEventListener delegate = (Xserv.OnXservEventListener)this.mDelegate.get();
        if (delegate != null) {
            this.mHandler.post(new Runnable(){

                @Override
                public void run() {
                    delegate.OnOpenConnection();
                }
            });
        }
    }

    protected void onCloseConnection(final Exception e) {
        final Xserv.OnXservEventListener delegate = (Xserv.OnXservEventListener)this.mDelegate.get();
        if (delegate != null) {
            this.mHandler.post(new Runnable(){

                @Override
                public void run() {
                    delegate.OnCloseConnection(e);
                }
            });
        }
    }

    protected void onErrorConnection(final Exception e) {
        final Xserv.OnXservEventListener delegate = (Xserv.OnXservEventListener)this.mDelegate.get();
        if (delegate != null) {
            this.mHandler.post(new Runnable(){

                @Override
                public void run() {
                    delegate.OnErrorConnection(e);
                }
            });
        }
    }

    protected void onReceiveMessages(final JSONObject json) {
        final Xserv.OnXservEventListener delegate = (Xserv.OnXservEventListener)this.mDelegate.get();
        if (delegate != null) {
            this.mHandler.post(new Runnable(){

                @Override
                public void run() {
                    delegate.OnReceiveMessages(json);
                }
            });
        }
    }

    protected void OnReceiveOperations(final JSONObject json) {
        final Xserv.OnXservEventListener delegate = (Xserv.OnXservEventListener)this.mDelegate.get();
        if (delegate != null) {
            this.mHandler.post(new Runnable(){

                @Override
                public void run() {
                    delegate.OnReceiveOperations(json);
                }
            });
        }
    }
}

