/*
 * Decompiled with CFR 0.152.
 */
package com.metamx.metrics;

import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.metamx.common.StreamUtils;
import com.metamx.common.logger.Logger;
import com.metamx.emitter.service.ServiceEmitter;
import com.metamx.emitter.service.ServiceMetricEvent;
import com.metamx.metrics.AbstractMonitor;
import com.metamx.metrics.KeyedDiff;
import com.metamx.metrics.MonitorUtils;
import java.io.File;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.hyperic.sigar.DirUsage;
import org.hyperic.sigar.DiskUsage;
import org.hyperic.sigar.FileSystemUsage;
import org.hyperic.sigar.Mem;
import org.hyperic.sigar.NetInterfaceConfig;
import org.hyperic.sigar.NetInterfaceStat;
import org.hyperic.sigar.NetStat;
import org.hyperic.sigar.Sigar;
import org.hyperic.sigar.SigarException;
import org.hyperic.sigar.SigarLoader;
import org.hyperic.sigar.Swap;
import org.hyperic.sigar.Tcp;
import org.hyperic.sigar.Uptime;

public class SysMonitor
extends AbstractMonitor {
    private static final Logger log = new Logger(SysMonitor.class);
    private final Sigar sigar = new Sigar();
    private final List<String> fsTypeWhitelist = ImmutableList.of((Object)"local");
    private final List<String> netAddressBlacklist = ImmutableList.of((Object)"0.0.0.0", (Object)"127.0.0.1");
    private final List<Stats> statsList;
    private Map<String, String[]> dimensions;

    public SysMonitor() {
        this((Map<String, String[]>)ImmutableMap.of());
    }

    public SysMonitor(Map<String, String[]> dimensions) {
        Preconditions.checkNotNull(dimensions);
        this.dimensions = ImmutableMap.copyOf(dimensions);
        this.statsList = new ArrayList<Stats>();
        this.statsList.addAll(Arrays.asList(new MemStats(), new FsStats(), new DiskStats(), new NetStats(), new CpuStats(), new SwapStats(), new SysStats(), new TcpStats()));
    }

    public void addDirectoriesToMonitor(String[] dirList) {
        for (int i = 0; i < dirList.length; ++i) {
            dirList[i] = dirList[i].trim();
        }
        this.statsList.add(new DirStats(dirList));
    }

    @Override
    public boolean doMonitor(ServiceEmitter emitter) {
        for (Stats stats : this.statsList) {
            stats.emit(emitter);
        }
        return true;
    }

    static {
        SigarLoader loader = new SigarLoader(Sigar.class);
        try {
            String libName = loader.getLibraryName();
            URL url = SysMonitor.class.getResource("/" + libName);
            if (url != null) {
                File tmpDir = File.createTempFile("yay", "yay");
                tmpDir.delete();
                tmpDir.mkdir();
                File nativeLibTmpFile = new File(tmpDir, libName);
                nativeLibTmpFile.deleteOnExit();
                StreamUtils.copyToFileAndClose((InputStream)url.openStream(), (File)nativeLibTmpFile);
                log.info("Loading sigar native lib at tmpPath[%s]", new Object[]{nativeLibTmpFile});
                loader.load(nativeLibTmpFile.getParent());
            } else {
                log.info("No native libs found in jar, letting the normal load mechanisms figger it out.", new Object[0]);
            }
        }
        catch (Exception e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    private class TcpStats
    implements Stats {
        private final KeyedDiff diff = new KeyedDiff();

        private TcpStats() {
        }

        @Override
        public void emit(ServiceEmitter emitter) {
            Map<String, Long> stats;
            ServiceMetricEvent.Builder builder = new ServiceMetricEvent.Builder();
            MonitorUtils.addDimensionsToBuilder(builder, SysMonitor.this.dimensions);
            Tcp tcp = null;
            try {
                tcp = SysMonitor.this.sigar.getTcp();
            }
            catch (SigarException e) {
                log.error((Throwable)e, "Failed to get Tcp", new Object[0]);
            }
            if (tcp != null && (stats = this.diff.to("tcp", (Map<String, Long>)ImmutableMap.builder().put((Object)"sys/tcp/activeOpens", (Object)tcp.getActiveOpens()).put((Object)"sys/tcp/passiveOpens", (Object)tcp.getPassiveOpens()).put((Object)"sys/tcp/attemptFails", (Object)tcp.getAttemptFails()).put((Object)"sys/tcp/estabResets", (Object)tcp.getEstabResets()).put((Object)"sys/tcp/in/segs", (Object)tcp.getInSegs()).put((Object)"sys/tcp/in/errs", (Object)tcp.getInErrs()).put((Object)"sys/tcp/out/segs", (Object)tcp.getOutSegs()).put((Object)"sys/tcp/out/rsts", (Object)tcp.getOutRsts()).put((Object)"sys/tcp/retrans/segs", (Object)tcp.getRetransSegs()).build())) != null) {
                for (Map.Entry<String, Long> entry : stats.entrySet()) {
                    emitter.emit(builder.build(entry.getKey(), (Number)entry.getValue()));
                }
            }
            NetStat netStat = null;
            try {
                netStat = SysMonitor.this.sigar.getNetStat();
            }
            catch (SigarException e) {
                log.error((Throwable)e, "Failed to get NetStat", new Object[0]);
            }
            if (netStat != null) {
                ImmutableMap stats2 = ImmutableMap.builder().put((Object)"sys/net/inbound", (Object)netStat.getAllInboundTotal()).put((Object)"sys/net/outbound", (Object)netStat.getAllOutboundTotal()).put((Object)"sys/tcp/inbound", (Object)netStat.getTcpInboundTotal()).put((Object)"sys/tcp/outbound", (Object)netStat.getTcpOutboundTotal()).put((Object)"sys/tcp/state/established", (Object)netStat.getTcpEstablished()).put((Object)"sys/tcp/state/synSent", (Object)netStat.getTcpSynSent()).put((Object)"sys/tcp/state/synRecv", (Object)netStat.getTcpSynRecv()).put((Object)"sys/tcp/state/finWait1", (Object)netStat.getTcpFinWait1()).put((Object)"sys/tcp/state/finWait2", (Object)netStat.getTcpFinWait2()).put((Object)"sys/tcp/state/timeWait", (Object)netStat.getTcpTimeWait()).put((Object)"sys/tcp/state/close", (Object)netStat.getTcpClose()).put((Object)"sys/tcp/state/closeWait", (Object)netStat.getTcpCloseWait()).put((Object)"sys/tcp/state/lastAck", (Object)netStat.getTcpLastAck()).put((Object)"sys/tcp/state/listen", (Object)netStat.getTcpListen()).put((Object)"sys/tcp/state/closing", (Object)netStat.getTcpClosing()).put((Object)"sys/tcp/state/idle", (Object)netStat.getTcpIdle()).put((Object)"sys/tcp/state/bound", (Object)netStat.getTcpBound()).build();
                for (Map.Entry entry : stats2.entrySet()) {
                    emitter.emit(builder.build((String)entry.getKey(), (Number)entry.getValue()));
                }
            }
        }
    }

    private class SysStats
    implements Stats {
        private SysStats() {
        }

        @Override
        public void emit(ServiceEmitter emitter) {
            ImmutableMap stats;
            ServiceMetricEvent.Builder builder = new ServiceMetricEvent.Builder();
            MonitorUtils.addDimensionsToBuilder(builder, SysMonitor.this.dimensions);
            Uptime uptime = null;
            try {
                uptime = SysMonitor.this.sigar.getUptime();
            }
            catch (SigarException e) {
                log.error((Throwable)e, "Failed to get Uptime", new Object[0]);
            }
            double[] la = null;
            try {
                la = SysMonitor.this.sigar.getLoadAverage();
            }
            catch (SigarException e) {
                log.error((Throwable)e, "Failed to get Load Average", new Object[0]);
            }
            if (uptime != null) {
                stats = ImmutableMap.of((Object)"sys/uptime", (Object)Double.valueOf(uptime.getUptime()).longValue());
                for (Map.Entry entry : stats.entrySet()) {
                    emitter.emit(builder.build((String)entry.getKey(), (Number)entry.getValue()));
                }
            }
            if (la != null) {
                stats = ImmutableMap.of((Object)"sys/la/1", (Object)la[0], (Object)"sys/la/5", (Object)la[1], (Object)"sys/la/15", (Object)la[2]);
                for (Map.Entry entry : stats.entrySet()) {
                    emitter.emit(builder.build((String)entry.getKey(), (Number)entry.getValue()));
                }
            }
        }
    }

    private class CpuStats
    implements Stats {
        private final KeyedDiff diff = new KeyedDiff();

        private CpuStats() {
        }

        @Override
        public void emit(ServiceEmitter emitter) {
            Object[] cpus = null;
            try {
                cpus = SysMonitor.this.sigar.getCpuList();
            }
            catch (SigarException e) {
                log.error((Throwable)e, "Failed to get Cpu list", new Object[0]);
            }
            if (cpus != null) {
                log.debug("Found Cpu list: [%s]", new Object[]{Joiner.on((String)", ").join(cpus)});
                for (int i = 0; i < cpus.length; ++i) {
                    Object cpu = cpus[i];
                    String name = Integer.toString(i);
                    Map<String, Long> stats = this.diff.to(name, (Map<String, Long>)ImmutableMap.builder().put((Object)"user", (Object)cpu.getUser()).put((Object)"sys", (Object)cpu.getSys()).put((Object)"nice", (Object)cpu.getNice()).put((Object)"wait", (Object)cpu.getWait()).put((Object)"irq", (Object)cpu.getIrq()).put((Object)"softIrq", (Object)cpu.getSoftIrq()).put((Object)"stolen", (Object)cpu.getStolen()).put((Object)"_total", (Object)cpu.getTotal()).build());
                    if (stats == null) continue;
                    long total = stats.remove("_total");
                    for (Map.Entry<String, Long> entry : stats.entrySet()) {
                        ServiceMetricEvent.Builder builder = new ServiceMetricEvent.Builder().setDimension("cpuName", name).setDimension("cpuTime", entry.getKey());
                        MonitorUtils.addDimensionsToBuilder(builder, SysMonitor.this.dimensions);
                        emitter.emit(builder.build("sys/cpu", (Number)(entry.getValue() * 100L / total)));
                    }
                }
            }
        }
    }

    private class NetStats
    implements Stats {
        private final KeyedDiff diff = new KeyedDiff();

        private NetStats() {
        }

        @Override
        public void emit(ServiceEmitter emitter) {
            Object[] ifaces = null;
            try {
                ifaces = SysMonitor.this.sigar.getNetInterfaceList();
            }
            catch (SigarException e) {
                log.error((Throwable)e, "Failed to get NetInterface list", new Object[0]);
            }
            if (ifaces != null) {
                log.debug("Found NetInterface list: [%s]", new Object[]{Joiner.on((String)", ").join(ifaces)});
                for (Object name : ifaces) {
                    NetInterfaceConfig netconf = null;
                    try {
                        netconf = SysMonitor.this.sigar.getNetInterfaceConfig((String)name);
                    }
                    catch (SigarException e) {
                        log.error((Throwable)e, "Failed to get NetInterfaceConfig[%s]", new Object[]{name});
                    }
                    if (netconf == null) continue;
                    if (!SysMonitor.this.netAddressBlacklist.contains(netconf.getAddress())) {
                        Map<String, Long> stats;
                        NetInterfaceStat netstat = null;
                        try {
                            netstat = SysMonitor.this.sigar.getNetInterfaceStat((String)name);
                        }
                        catch (SigarException e) {
                            log.error((Throwable)e, "Failed to get NetInterfaceStat[%s]", new Object[]{name});
                        }
                        if (netstat == null || (stats = this.diff.to((String)name, (Map<String, Long>)ImmutableMap.builder().put((Object)"sys/net/read/size", (Object)netstat.getRxBytes()).put((Object)"sys/net/read/packets", (Object)netstat.getRxPackets()).put((Object)"sys/net/read/errors", (Object)netstat.getRxErrors()).put((Object)"sys/net/read/dropped", (Object)netstat.getRxDropped()).put((Object)"sys/net/read/overruns", (Object)netstat.getRxOverruns()).put((Object)"sys/net/read/frame", (Object)netstat.getRxFrame()).put((Object)"sys/net/write/size", (Object)netstat.getTxBytes()).put((Object)"sys/net/write/packets", (Object)netstat.getTxPackets()).put((Object)"sys/net/write/errors", (Object)netstat.getTxErrors()).put((Object)"sys/net/write/dropped", (Object)netstat.getTxDropped()).put((Object)"sys/net/write/collisions", (Object)netstat.getTxCollisions()).put((Object)"sys/net/write/overruns", (Object)netstat.getTxOverruns()).build())) == null) continue;
                        ServiceMetricEvent.Builder builder = new ServiceMetricEvent.Builder().setDimension("netName", netconf.getName()).setDimension("netAddress", netconf.getAddress()).setDimension("netHwaddr", netconf.getHwaddr());
                        MonitorUtils.addDimensionsToBuilder(builder, SysMonitor.this.dimensions);
                        for (Map.Entry<String, Long> entry : stats.entrySet()) {
                            emitter.emit(builder.build(entry.getKey(), (Number)entry.getValue()));
                        }
                        continue;
                    }
                    log.debug("Not monitoring net stats for name[%s] with address[%s]", new Object[]{name, netconf.getAddress()});
                }
            }
        }
    }

    private class DiskStats
    implements Stats {
        private final KeyedDiff diff = new KeyedDiff();

        private DiskStats() {
        }

        @Override
        public void emit(ServiceEmitter emitter) {
            Object[] fss = null;
            try {
                fss = SysMonitor.this.sigar.getFileSystemList();
            }
            catch (SigarException e) {
                log.error((Throwable)e, "Failed to get FileSystem list", new Object[0]);
            }
            if (fss != null) {
                log.debug("Found FileSystem list: [%s]", new Object[]{Joiner.on((String)", ").join(fss)});
                for (Object fs : fss) {
                    String name = fs.getDevName();
                    if (SysMonitor.this.fsTypeWhitelist.contains(fs.getTypeName())) {
                        Map<String, Long> stats;
                        DiskUsage du = null;
                        try {
                            du = SysMonitor.this.sigar.getDiskUsage(name);
                        }
                        catch (SigarException e) {
                            log.error((Throwable)e, "Failed to get DiskUsage[%s]", new Object[]{name});
                        }
                        if (du == null || (stats = this.diff.to(name, (Map<String, Long>)ImmutableMap.builder().put((Object)"sys/disk/read/size", (Object)du.getReadBytes()).put((Object)"sys/disk/read/count", (Object)du.getReads()).put((Object)"sys/disk/write/size", (Object)du.getWriteBytes()).put((Object)"sys/disk/write/count", (Object)du.getWrites()).put((Object)"sys/disk/queue", (Object)Double.valueOf(du.getQueue()).longValue()).put((Object)"sys/disk/serviceTime", (Object)Double.valueOf(du.getServiceTime()).longValue()).build())) == null) continue;
                        ServiceMetricEvent.Builder builder = new ServiceMetricEvent.Builder().setDimension("fsDevName", fs.getDevName()).setDimension("fsDirName", fs.getDirName()).setDimension("fsTypeName", fs.getTypeName()).setDimension("fsSysTypeName", fs.getSysTypeName()).setDimension("fsOptions", fs.getOptions().split(","));
                        MonitorUtils.addDimensionsToBuilder(builder, SysMonitor.this.dimensions);
                        for (Map.Entry<String, Long> entry : stats.entrySet()) {
                            emitter.emit(builder.build(entry.getKey(), (Number)entry.getValue()));
                        }
                        continue;
                    }
                    log.debug("Not monitoring disk stats for name[%s] with typeName[%s]", new Object[]{name, fs.getTypeName()});
                }
            }
        }
    }

    private class FsStats
    implements Stats {
        private FsStats() {
        }

        @Override
        public void emit(ServiceEmitter emitter) {
            Object[] fss = null;
            try {
                fss = SysMonitor.this.sigar.getFileSystemList();
            }
            catch (SigarException e) {
                log.error((Throwable)e, "Failed to get FileSystem list", new Object[0]);
            }
            if (fss != null) {
                log.debug("Found FileSystem list: [%s]", new Object[]{Joiner.on((String)", ").join(fss)});
                for (Object fs : fss) {
                    String name = fs.getDirName();
                    if (SysMonitor.this.fsTypeWhitelist.contains(fs.getTypeName())) {
                        FileSystemUsage fsu = null;
                        try {
                            fsu = SysMonitor.this.sigar.getFileSystemUsage(name);
                        }
                        catch (SigarException e) {
                            log.error((Throwable)e, "Failed to get FileSystemUsage[%s]", new Object[]{name});
                        }
                        if (fsu == null) continue;
                        ImmutableMap stats = ImmutableMap.builder().put((Object)"sys/fs/max", (Object)(fsu.getTotal() * 1024L)).put((Object)"sys/fs/used", (Object)(fsu.getUsed() * 1024L)).put((Object)"sys/fs/files/count", (Object)fsu.getFiles()).put((Object)"sys/fs/files/free", (Object)fsu.getFreeFiles()).build();
                        ServiceMetricEvent.Builder builder = new ServiceMetricEvent.Builder().setDimension("fsDevName", fs.getDevName()).setDimension("fsDirName", fs.getDirName()).setDimension("fsTypeName", fs.getTypeName()).setDimension("fsSysTypeName", fs.getSysTypeName()).setDimension("fsOptions", fs.getOptions().split(","));
                        MonitorUtils.addDimensionsToBuilder(builder, SysMonitor.this.dimensions);
                        for (Map.Entry entry : stats.entrySet()) {
                            emitter.emit(builder.build((String)entry.getKey(), (Number)entry.getValue()));
                        }
                        continue;
                    }
                    log.debug("Not monitoring fs stats for name[%s] with typeName[%s]", new Object[]{name, fs.getTypeName()});
                }
            }
        }
    }

    private class DirStats
    implements Stats {
        private final String[] dirList;

        private DirStats(String[] dirList) {
            this.dirList = dirList;
        }

        @Override
        public void emit(ServiceEmitter emitter) {
            for (String dir : this.dirList) {
                DirUsage du = null;
                try {
                    du = SysMonitor.this.sigar.getDirUsage(dir);
                }
                catch (SigarException e) {
                    log.error("Failed to get DiskUsage for [%s] due to   [%s]", new Object[]{dir, e.getMessage()});
                }
                if (du == null) continue;
                ImmutableMap stats = ImmutableMap.of((Object)"sys/storage/used", (Object)du.getDiskUsage());
                ServiceMetricEvent.Builder builder = new ServiceMetricEvent.Builder().setDimension("fsDirName", dir);
                MonitorUtils.addDimensionsToBuilder(builder, SysMonitor.this.dimensions);
                for (Map.Entry entry : stats.entrySet()) {
                    emitter.emit(builder.build((String)entry.getKey(), (Number)entry.getValue()));
                }
            }
        }
    }

    private class SwapStats
    implements Stats {
        private long prevPageIn = 0L;
        private long prevPageOut = 0L;

        private SwapStats() {
            try {
                Swap swap = SysMonitor.this.sigar.getSwap();
                this.prevPageIn = swap.getPageIn();
                this.prevPageOut = swap.getPageOut();
            }
            catch (SigarException e) {
                log.error((Throwable)e, "Failed to get Swap", new Object[0]);
            }
        }

        @Override
        public void emit(ServiceEmitter emitter) {
            Swap swap = null;
            try {
                swap = SysMonitor.this.sigar.getSwap();
            }
            catch (SigarException e) {
                log.error((Throwable)e, "Failed to get Swap", new Object[0]);
            }
            if (swap != null) {
                long currPageIn = swap.getPageIn();
                long currPageOut = swap.getPageOut();
                ImmutableMap stats = ImmutableMap.of((Object)"sys/swap/pageIn", (Object)(currPageIn - this.prevPageIn), (Object)"sys/swap/pageOut", (Object)(currPageOut - this.prevPageOut), (Object)"sys/swap/max", (Object)swap.getTotal(), (Object)"sys/swap/free", (Object)swap.getFree());
                ServiceMetricEvent.Builder builder = new ServiceMetricEvent.Builder();
                MonitorUtils.addDimensionsToBuilder(builder, SysMonitor.this.dimensions);
                for (Map.Entry entry : stats.entrySet()) {
                    emitter.emit(builder.build((String)entry.getKey(), (Number)entry.getValue()));
                }
                this.prevPageIn = currPageIn;
                this.prevPageOut = currPageOut;
            }
        }
    }

    private class MemStats
    implements Stats {
        private MemStats() {
        }

        @Override
        public void emit(ServiceEmitter emitter) {
            Mem mem = null;
            try {
                mem = SysMonitor.this.sigar.getMem();
            }
            catch (SigarException e) {
                log.error((Throwable)e, "Failed to get Mem", new Object[0]);
            }
            if (mem != null) {
                ImmutableMap stats = ImmutableMap.of((Object)"sys/mem/max", (Object)mem.getTotal(), (Object)"sys/mem/used", (Object)mem.getUsed(), (Object)"sys/mem/actual/used", (Object)mem.getActualUsed(), (Object)"sys/mem/actual/free", (Object)mem.getActualFree());
                ServiceMetricEvent.Builder builder = new ServiceMetricEvent.Builder();
                MonitorUtils.addDimensionsToBuilder(builder, SysMonitor.this.dimensions);
                for (Map.Entry entry : stats.entrySet()) {
                    emitter.emit(builder.build((String)entry.getKey(), (Number)entry.getValue()));
                }
            }
        }
    }

    private static interface Stats {
        public void emit(ServiceEmitter var1);
    }
}

