/*
 * Decompiled with CFR 0.152.
 */
package com.metamx.common;

import com.google.common.base.Predicate;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.io.ByteSource;
import com.google.common.io.FileWriteMode;
import com.google.common.io.Files;
import com.metamx.common.StreamUtils;
import java.io.File;
import java.util.Arrays;
import java.util.Collection;

public class FileUtils {
    public static final Predicate<Throwable> IS_EXCEPTION = new Predicate<Throwable>(){

        public boolean apply(Throwable input) {
            return input instanceof Exception;
        }
    };

    public static FileCopyResult retryCopy(ByteSource byteSource, File outFile, Predicate<Throwable> shouldRetry, int maxAttempts) {
        try {
            StreamUtils.retryCopy(byteSource, Files.asByteSink((File)outFile, (FileWriteMode[])new FileWriteMode[0]), shouldRetry, maxAttempts);
            return new FileCopyResult(outFile);
        }
        catch (Exception e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    public static class FileCopyResult {
        private final Collection<File> files = Lists.newArrayList();
        private long size = 0L;

        public Collection<File> getFiles() {
            return ImmutableList.copyOf(this.files);
        }

        public long size() {
            return this.size;
        }

        public FileCopyResult(File ... files) {
            this((Collection<File>)(files == null ? ImmutableList.of() : Arrays.asList(files)));
        }

        public FileCopyResult(Collection<File> files) {
            this.addSizedFiles(files);
        }

        protected void addSizedFiles(Collection<File> files) {
            if (files == null || files.isEmpty()) {
                return;
            }
            long size = 0L;
            for (File file : files) {
                size += file.length();
            }
            this.files.addAll(files);
            this.size += size;
        }

        public void addFiles(Collection<File> files) {
            this.addSizedFiles(files);
        }

        public void addFile(File file) {
            this.addFiles((Collection<File>)ImmutableList.of((Object)file));
        }
    }
}

