/*
 * Decompiled with CFR 0.152.
 */
package com.metamx.common.logger;

import java.util.MissingFormatArgumentException;
import org.slf4j.LoggerFactory;

public class Logger {
    private final org.slf4j.Logger log;

    public Logger(String name) {
        this.log = LoggerFactory.getLogger((String)name);
    }

    public Logger(Class clazz) {
        this.log = LoggerFactory.getLogger((Class)clazz);
    }

    public void trace(String message, Object ... formatArgs) {
        if (this.log.isTraceEnabled()) {
            this.log.trace(this.safeFormat(message, formatArgs));
        }
    }

    public void trace(Throwable t, String message, Object ... formatArgs) {
        if (this.log.isTraceEnabled()) {
            this.log.trace(this.safeFormat(message, formatArgs), t);
        }
    }

    public void debug(String message, Object ... formatArgs) {
        if (this.log.isDebugEnabled()) {
            this.log.debug(this.safeFormat(message, formatArgs));
        }
    }

    public void debug(Throwable t, String message, Object ... formatArgs) {
        if (this.log.isDebugEnabled()) {
            this.log.debug(this.safeFormat(message, formatArgs), t);
        }
    }

    public void info(String message, Object ... formatArgs) {
        if (this.log.isInfoEnabled()) {
            this.log.info(this.safeFormat(message, formatArgs));
        }
    }

    public void info(Throwable t, String message, Object ... formatArgs) {
        if (this.log.isInfoEnabled()) {
            this.log.info(this.safeFormat(message, formatArgs), t);
        }
    }

    public void warn(String message, Object ... formatArgs) {
        this.log.warn(this.safeFormat(message, formatArgs));
    }

    public void warn(Throwable t, String message, Object ... formatArgs) {
        this.log.warn(this.safeFormat(message, formatArgs), t);
    }

    public void error(String message, Object ... formatArgs) {
        this.log.error(this.safeFormat(message, formatArgs));
    }

    public void error(Throwable t, String message, Object ... formatArgs) {
        this.log.error(this.safeFormat(message, formatArgs), t);
    }

    public void wtf(String message, Object ... formatArgs) {
        this.log.error(this.safeFormat("WTF?!: " + message, formatArgs), (Throwable)new Exception());
    }

    public void wtf(Throwable t, String message, Object ... formatArgs) {
        this.log.error(this.safeFormat("WTF?!: " + message, formatArgs), t);
    }

    private String safeFormat(String message, Object ... formatArgs) {
        try {
            return String.format(message, formatArgs);
        }
        catch (MissingFormatArgumentException e) {
            StringBuilder bob = new StringBuilder(message);
            for (Object formatArg : formatArgs) {
                bob.append("; ").append(formatArg);
            }
            return bob.toString();
        }
    }

    public boolean isTraceEnabled() {
        return this.log.isTraceEnabled();
    }

    public boolean isDebugEnabled() {
        return this.log.isDebugEnabled();
    }

    public boolean isInfoEnabled() {
        return this.log.isInfoEnabled();
    }
}

