/*
 * Decompiled with CFR 0.152.
 */
package com.metamx.http.client.pool;

import com.google.common.base.Preconditions;
import com.metamx.common.logger.Logger;
import com.metamx.http.client.pool.ResourceFactory;
import java.net.InetSocketAddress;
import java.net.MalformedURLException;
import java.net.SocketAddress;
import java.net.URL;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLParameters;
import org.jboss.netty.bootstrap.ClientBootstrap;
import org.jboss.netty.channel.Channel;
import org.jboss.netty.channel.ChannelException;
import org.jboss.netty.channel.ChannelFuture;
import org.jboss.netty.channel.ChannelFutureListener;
import org.jboss.netty.channel.ChannelHandler;
import org.jboss.netty.channel.ChannelPipeline;
import org.jboss.netty.channel.Channels;
import org.jboss.netty.handler.ssl.SslHandler;
import org.jboss.netty.util.Timer;

public class ChannelResourceFactory
implements ResourceFactory<String, ChannelFuture> {
    private static final Logger log = new Logger(ChannelResourceFactory.class);
    private static final long DEFAULT_SSL_HANDSHAKE_TIMEOUT = 10000L;
    private final ClientBootstrap bootstrap;
    private final SSLContext sslContext;
    private final Timer timer;
    private final long sslHandshakeTimeout;

    public ChannelResourceFactory(ClientBootstrap bootstrap, SSLContext sslContext, Timer timer, long sslHandshakeTimeout) {
        this.bootstrap = (ClientBootstrap)Preconditions.checkNotNull((Object)bootstrap, (Object)"bootstrap");
        this.sslContext = sslContext;
        this.timer = timer;
        long l = this.sslHandshakeTimeout = sslHandshakeTimeout >= 0L ? sslHandshakeTimeout : 10000L;
        if (sslContext != null) {
            Preconditions.checkNotNull((Object)timer, (Object)"timer is required when sslContext is present");
        }
    }

    @Override
    public ChannelFuture generate(final String hostname) {
        ChannelFuture retVal;
        log.info(String.format("Generating: %s", hostname), new Object[0]);
        URL url = null;
        try {
            url = new URL(hostname);
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e);
        }
        String host = url.getHost();
        int port = url.getPort() == -1 ? url.getDefaultPort() : url.getPort();
        ChannelFuture connectFuture = this.bootstrap.connect((SocketAddress)new InetSocketAddress(host, port));
        if ("https".equals(url.getProtocol())) {
            if (this.sslContext == null) {
                throw new IllegalStateException("No sslContext set, cannot do https");
            }
            SSLEngine sslEngine = this.sslContext.createSSLEngine(host, port);
            SSLParameters sslParameters = new SSLParameters();
            sslParameters.setEndpointIdentificationAlgorithm("HTTPS");
            sslEngine.setSSLParameters(sslParameters);
            sslEngine.setUseClientMode(true);
            final SslHandler sslHandler = new SslHandler(sslEngine, SslHandler.getDefaultBufferPool(), false, this.timer, this.sslHandshakeTimeout);
            sslHandler.setCloseOnSSLException(true);
            ChannelPipeline pipeline = connectFuture.getChannel().getPipeline();
            pipeline.addFirst("ssl", (ChannelHandler)sslHandler);
            final ChannelFuture handshakeFuture = Channels.future((Channel)connectFuture.getChannel());
            connectFuture.addListener(new ChannelFutureListener(){

                public void operationComplete(ChannelFuture f) throws Exception {
                    if (f.isSuccess()) {
                        sslHandler.handshake().addListener(new ChannelFutureListener(){

                            public void operationComplete(ChannelFuture f2) throws Exception {
                                if (f2.isSuccess()) {
                                    handshakeFuture.setSuccess();
                                } else {
                                    handshakeFuture.setFailure((Throwable)new ChannelException(String.format("Failed to handshake with host[%s]", hostname), f2.getCause()));
                                }
                            }
                        });
                    } else {
                        handshakeFuture.setFailure((Throwable)new ChannelException(String.format("Failed to connect to host[%s]", hostname), f.getCause()));
                    }
                }
            });
            retVal = handshakeFuture;
        } else {
            retVal = connectFuture;
        }
        return retVal;
    }

    @Override
    public boolean isGood(ChannelFuture resource) {
        Channel channel = resource.awaitUninterruptibly().getChannel();
        boolean isSuccess = resource.isSuccess();
        boolean isConnected = channel.isConnected();
        boolean isOpen = channel.isOpen();
        if (log.isTraceEnabled()) {
            log.trace("isGood = isSucess[%s] && isConnected[%s] && isOpen[%s]", new Object[]{isSuccess, isConnected, isOpen});
        }
        return isSuccess && isConnected && isOpen;
    }

    @Override
    public void close(ChannelFuture resource) {
        log.trace("Closing", new Object[0]);
        resource.awaitUninterruptibly().getChannel().close();
    }
}

