/*
 * Decompiled with CFR 0.152.
 */
package com.mercadopago.client.user;

import com.mercadopago.MercadoPagoConfig;
import com.mercadopago.client.MercadoPagoClient;
import com.mercadopago.core.MPRequestOptions;
import com.mercadopago.exceptions.MPApiException;
import com.mercadopago.exceptions.MPException;
import com.mercadopago.net.HttpMethod;
import com.mercadopago.net.MPHttpClient;
import com.mercadopago.net.MPResponse;
import com.mercadopago.resources.user.User;
import com.mercadopago.serialization.Serializer;
import java.util.logging.Logger;
import java.util.logging.StreamHandler;

public class UserClient
extends MercadoPagoClient {
    private static final Logger LOGGER = Logger.getLogger(UserClient.class.getName());

    public UserClient() {
        this(MercadoPagoConfig.getHttpClient());
    }

    public UserClient(MPHttpClient httpClient) {
        super(httpClient);
        StreamHandler streamHandler = MercadoPagoConfig.getStreamHandler();
        streamHandler.setLevel(MercadoPagoConfig.getLoggingLevel());
        LOGGER.addHandler(streamHandler);
        LOGGER.setLevel(MercadoPagoConfig.getLoggingLevel());
    }

    public User get() throws MPException, MPApiException {
        return this.get(null);
    }

    public User get(MPRequestOptions requestOptions) throws MPException, MPApiException {
        LOGGER.info("Sending get user request");
        MPResponse response = this.send("/users/me", HttpMethod.GET, null, null, requestOptions);
        User user = Serializer.deserializeFromJson(User.class, response.getContent());
        user.setResponse(response);
        return user;
    }
}

