/*
 * Decompiled with CFR 0.152.
 */
package com.mercadopago.client.common;

public class AddressRequest {
    private final String zipCode;
    private final String streetName;
    private final String streetNumber;

    AddressRequest(String zipCode, String streetName, String streetNumber) {
        this.zipCode = zipCode;
        this.streetName = streetName;
        this.streetNumber = streetNumber;
    }

    public static AddressRequestBuilder builder() {
        return new AddressRequestBuilder();
    }

    public String getZipCode() {
        return this.zipCode;
    }

    public String getStreetName() {
        return this.streetName;
    }

    public String getStreetNumber() {
        return this.streetNumber;
    }

    public static class AddressRequestBuilder {
        private String zipCode;
        private String streetName;
        private String streetNumber;

        AddressRequestBuilder() {
        }

        public AddressRequestBuilder zipCode(String zipCode) {
            this.zipCode = zipCode;
            return this;
        }

        public AddressRequestBuilder streetName(String streetName) {
            this.streetName = streetName;
            return this;
        }

        public AddressRequestBuilder streetNumber(String streetNumber) {
            this.streetNumber = streetNumber;
            return this;
        }

        public AddressRequest build() {
            return new AddressRequest(this.zipCode, this.streetName, this.streetNumber);
        }

        public String toString() {
            return "AddressRequest.AddressRequestBuilder(zipCode=" + this.zipCode + ", streetName=" + this.streetName + ", streetNumber=" + this.streetNumber + ")";
        }
    }
}

