/*
 * Decompiled with CFR 0.152.
 */
package com.mercadopago.serialization;

import com.google.gson.FieldNamingPolicy;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.JsonPrimitive;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import com.google.gson.stream.MalformedJsonException;
import com.mercadopago.exceptions.MPJsonParseException;
import com.mercadopago.net.MPElementsResourcesPage;
import com.mercadopago.net.MPResource;
import com.mercadopago.net.MPResourceList;
import com.mercadopago.net.MPResultsResourcesPage;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.lang.reflect.Type;
import java.time.LocalDate;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import java.time.temporal.TemporalAccessor;
import java.util.ArrayList;

public class Serializer {
    private static final DateTimeFormatter DESERIALIZE_DATE_FORMAT_ISO8601_EXTENDED = DateTimeFormatter.ofPattern("yyyy-MM-dd'T'HH:mm:ss[.SSS][XXX][XX][X]");
    private static final DateTimeFormatter DESERIALIZE_DATE_FORMAT_ISO8601_BASIC = DateTimeFormatter.ofPattern("yyyyMMdd'T'HHmmss[.SSS][XXX][XX][X]");
    private static final DateTimeFormatter[] ISO8601_DATETIME_FORMATTERS = new DateTimeFormatter[]{DateTimeFormatter.ISO_DATE_TIME, DESERIALIZE_DATE_FORMAT_ISO8601_EXTENDED, DESERIALIZE_DATE_FORMAT_ISO8601_BASIC};
    private static final String SERIALIZE_DATE_FORMAT_ISO8601 = "yyyy-MM-dd'T'HH:mm:ss.SSSXXX";
    private static final Gson GSON = new GsonBuilder().registerTypeAdapter(OffsetDateTime.class, (json, type, context) -> Serializer.parseDateTime(json)).registerTypeAdapter(OffsetDateTime.class, (offsetDateTime, type, context) -> new JsonPrimitive(DateTimeFormatter.ofPattern(SERIALIZE_DATE_FORMAT_ISO8601).format((TemporalAccessor)offsetDateTime))).registerTypeAdapter(LocalDate.class, (localDate, type, context) -> new JsonPrimitive(localDate.format(DateTimeFormatter.ISO_LOCAL_DATE))).registerTypeAdapter(LocalDate.class, (localDate, type, context) -> LocalDate.parse(localDate.getAsString())).setFieldNamingPolicy(FieldNamingPolicy.LOWER_CASE_WITH_UNDERSCORES).create();

    private static OffsetDateTime parseDateTime(JsonElement json) {
        if (json == null || json.getAsString().isEmpty()) {
            return null;
        }
        for (int i = 0; i < ISO8601_DATETIME_FORMATTERS.length; ++i) {
            try {
                return OffsetDateTime.parse(json.getAsString(), ISO8601_DATETIME_FORMATTERS[i]);
            }
            catch (DateTimeParseException e) {
                if (i != ISO8601_DATETIME_FORMATTERS.length - 1) continue;
                throw e;
            }
        }
        return null;
    }

    public static <T extends MPResource> T deserializeFromJson(Class<T> clazz, String jsonObject) throws MPJsonParseException {
        try {
            if (Serializer.isJsonValid(jsonObject)) {
                return (T)((MPResource)GSON.fromJson(jsonObject, clazz));
            }
            throw new MPJsonParseException(String.format("Could not parse json: %s", jsonObject));
        }
        catch (IOException e) {
            throw new MPJsonParseException("Could not parse json", e);
        }
    }

    public static <T extends MPResource> MPResultsResourcesPage<T> deserializeResultsResourcesPageFromJson(Type type, String jsonObject) throws MPJsonParseException {
        try {
            if (Serializer.isJsonValid(jsonObject)) {
                return (MPResultsResourcesPage)GSON.fromJson(jsonObject, type);
            }
            throw new MPJsonParseException(String.format("Could not parse json: %s", jsonObject));
        }
        catch (IOException e) {
            throw new MPJsonParseException("Could not parse json", e);
        }
    }

    public static <T extends MPResource> MPElementsResourcesPage<T> deserializeElementsResourcesPageFromJson(Type type, String jsonObject) throws MPJsonParseException {
        try {
            if (Serializer.isJsonValid(jsonObject)) {
                return (MPElementsResourcesPage)GSON.fromJson(jsonObject, type);
            }
            throw new MPJsonParseException(String.format("Could not parse json: %s", jsonObject));
        }
        catch (MPJsonParseException | IOException e) {
            throw new MPJsonParseException("Could not parse json", e);
        }
    }

    public static <T extends MPResource> MPResourceList<T> deserializeListFromJson(Class<T> clazz, String jsonObject) throws MPJsonParseException {
        try {
            if (Serializer.isJsonValid(jsonObject)) {
                MPResourceList resourceList = new MPResourceList();
                ArrayList<MPResource> results = new ArrayList<MPResource>();
                JsonArray jsonArray = JsonParser.parseString((String)jsonObject).getAsJsonArray();
                for (int i = 0; i < jsonArray.size(); ++i) {
                    MPResource resource = (MPResource)GSON.fromJson(jsonArray.get(i), clazz);
                    results.add(resource);
                }
                resourceList.setResults(results);
                return resourceList;
            }
            throw new MPJsonParseException(String.format("Could not parse json: %s", jsonObject));
        }
        catch (IOException e) {
            throw new MPJsonParseException("Could not parse json", e);
        }
    }

    public static <T> JsonObject serializeToJson(T resource) {
        return (JsonObject)GSON.toJsonTree(resource);
    }

    public static boolean isJsonValid(String json) throws IOException {
        try {
            JsonToken token;
            JsonReader jsonReader = new JsonReader((Reader)new StringReader(json));
            block11: while ((token = jsonReader.peek()) != JsonToken.END_DOCUMENT && token != null) {
                switch (token) {
                    case BEGIN_ARRAY: {
                        jsonReader.beginArray();
                        continue block11;
                    }
                    case END_ARRAY: {
                        jsonReader.endArray();
                        continue block11;
                    }
                    case BEGIN_OBJECT: {
                        jsonReader.beginObject();
                        continue block11;
                    }
                    case END_OBJECT: {
                        jsonReader.endObject();
                        continue block11;
                    }
                    case NAME: {
                        jsonReader.nextName();
                        continue block11;
                    }
                    case STRING: 
                    case NUMBER: 
                    case BOOLEAN: 
                    case NULL: {
                        jsonReader.skipValue();
                        continue block11;
                    }
                    case END_DOCUMENT: {
                        break block11;
                    }
                    default: {
                        throw new AssertionError(token);
                    }
                }
            }
            return true;
        }
        catch (MalformedJsonException ignored) {
            return false;
        }
    }
}

