/*
 * Decompiled with CFR 0.152.
 */
package com.mercadopago.client.preference;

import com.google.gson.reflect.TypeToken;
import com.mercadopago.MercadoPagoConfig;
import com.mercadopago.client.MercadoPagoClient;
import com.mercadopago.client.preference.PreferenceRequest;
import com.mercadopago.core.MPRequestOptions;
import com.mercadopago.exceptions.MPApiException;
import com.mercadopago.exceptions.MPException;
import com.mercadopago.net.HttpMethod;
import com.mercadopago.net.MPElementsResourcesPage;
import com.mercadopago.net.MPHttpClient;
import com.mercadopago.net.MPRequest;
import com.mercadopago.net.MPResponse;
import com.mercadopago.net.MPSearchRequest;
import com.mercadopago.resources.preference.Preference;
import com.mercadopago.resources.preference.PreferenceSearch;
import com.mercadopago.serialization.Serializer;
import java.lang.reflect.Type;
import java.util.logging.Logger;
import java.util.logging.StreamHandler;

public class PreferenceClient
extends MercadoPagoClient {
    private static final Logger LOGGER = Logger.getLogger(PreferenceClient.class.getName());
    private static final String URL_WITH_ID = "/checkout/preferences/%s";

    public PreferenceClient() {
        this(MercadoPagoConfig.getHttpClient());
    }

    public PreferenceClient(MPHttpClient httpClient) {
        super(httpClient);
        StreamHandler streamHandler = MercadoPagoConfig.getStreamHandler();
        streamHandler.setLevel(MercadoPagoConfig.getLoggingLevel());
        LOGGER.addHandler(streamHandler);
        LOGGER.setLevel(MercadoPagoConfig.getLoggingLevel());
    }

    public Preference get(String id) throws MPException, MPApiException {
        return this.get(id, null);
    }

    public Preference get(String id, MPRequestOptions requestOptions) throws MPException, MPApiException {
        LOGGER.info("Sending get preference request");
        MPResponse response = this.send(String.format(URL_WITH_ID, id), HttpMethod.GET, null, null, requestOptions);
        Preference result = Serializer.deserializeFromJson(Preference.class, response.getContent());
        result.setResponse(response);
        return result;
    }

    public Preference create(PreferenceRequest request) throws MPException, MPApiException {
        return this.create(request, null);
    }

    public Preference create(PreferenceRequest request, MPRequestOptions requestOptions) throws MPException, MPApiException {
        LOGGER.info("Sending create preference request");
        MPRequest mpRequest = MPRequest.builder().uri("/checkout/preferences").method(HttpMethod.POST).payload(Serializer.serializeToJson(request)).build();
        MPResponse response = this.send(mpRequest, requestOptions);
        Preference result = Serializer.deserializeFromJson(Preference.class, response.getContent());
        result.setResponse(response);
        return result;
    }

    public Preference update(String id, PreferenceRequest request) throws MPException, MPApiException {
        return this.update(id, request, null);
    }

    public Preference update(String id, PreferenceRequest request, MPRequestOptions requestOptions) throws MPException, MPApiException {
        LOGGER.info("Sending update preference request");
        MPRequest mpRequest = MPRequest.builder().uri(String.format(URL_WITH_ID, id)).method(HttpMethod.PUT).payload(Serializer.serializeToJson(request)).build();
        MPResponse response = this.send(mpRequest, requestOptions);
        Preference result = Serializer.deserializeFromJson(Preference.class, response.getContent());
        result.setResponse(response);
        return result;
    }

    public MPElementsResourcesPage<PreferenceSearch> search(MPSearchRequest request) throws MPException, MPApiException {
        return this.search(request, null);
    }

    public MPElementsResourcesPage<PreferenceSearch> search(MPSearchRequest request, MPRequestOptions requestOptions) throws MPException, MPApiException {
        LOGGER.info("Sending search preference request");
        MPResponse response = this.search("/checkout/preferences/search", request, requestOptions);
        Type responseType = new TypeToken<MPElementsResourcesPage<PreferenceSearch>>(){}.getType();
        MPElementsResourcesPage<PreferenceSearch> result = Serializer.deserializeElementsResourcesPageFromJson(responseType, response.getContent());
        result.setResponse(response);
        return result;
    }
}

