/*
 * Decompiled with CFR 0.152.
 */
package com.mercadopago.client.payment;

public class PaymentAuthenticationRequest {
    private final String type;
    private final String cryptogram;
    private final String threeDsServerTransId;
    private final String eci;
    private final String dsTransId;
    private final String acsTransId;
    private final String threeDsVersion;
    private final String authenticationStatus;

    PaymentAuthenticationRequest(String type, String cryptogram, String threeDsServerTransId, String eci, String dsTransId, String acsTransId, String threeDsVersion, String authenticationStatus) {
        this.type = type;
        this.cryptogram = cryptogram;
        this.threeDsServerTransId = threeDsServerTransId;
        this.eci = eci;
        this.dsTransId = dsTransId;
        this.acsTransId = acsTransId;
        this.threeDsVersion = threeDsVersion;
        this.authenticationStatus = authenticationStatus;
    }

    public static PaymentAuthenticationRequestBuilder builder() {
        return new PaymentAuthenticationRequestBuilder();
    }

    public String getType() {
        return this.type;
    }

    public String getCryptogram() {
        return this.cryptogram;
    }

    public String getThreeDsServerTransId() {
        return this.threeDsServerTransId;
    }

    public String getEci() {
        return this.eci;
    }

    public String getDsTransId() {
        return this.dsTransId;
    }

    public String getAcsTransId() {
        return this.acsTransId;
    }

    public String getThreeDsVersion() {
        return this.threeDsVersion;
    }

    public String getAuthenticationStatus() {
        return this.authenticationStatus;
    }

    public static class PaymentAuthenticationRequestBuilder {
        private String type;
        private String cryptogram;
        private String threeDsServerTransId;
        private String eci;
        private String dsTransId;
        private String acsTransId;
        private String threeDsVersion;
        private String authenticationStatus;

        PaymentAuthenticationRequestBuilder() {
        }

        public PaymentAuthenticationRequestBuilder type(String type) {
            this.type = type;
            return this;
        }

        public PaymentAuthenticationRequestBuilder cryptogram(String cryptogram) {
            this.cryptogram = cryptogram;
            return this;
        }

        public PaymentAuthenticationRequestBuilder threeDsServerTransId(String threeDsServerTransId) {
            this.threeDsServerTransId = threeDsServerTransId;
            return this;
        }

        public PaymentAuthenticationRequestBuilder eci(String eci) {
            this.eci = eci;
            return this;
        }

        public PaymentAuthenticationRequestBuilder dsTransId(String dsTransId) {
            this.dsTransId = dsTransId;
            return this;
        }

        public PaymentAuthenticationRequestBuilder acsTransId(String acsTransId) {
            this.acsTransId = acsTransId;
            return this;
        }

        public PaymentAuthenticationRequestBuilder threeDsVersion(String threeDsVersion) {
            this.threeDsVersion = threeDsVersion;
            return this;
        }

        public PaymentAuthenticationRequestBuilder authenticationStatus(String authenticationStatus) {
            this.authenticationStatus = authenticationStatus;
            return this;
        }

        public PaymentAuthenticationRequest build() {
            return new PaymentAuthenticationRequest(this.type, this.cryptogram, this.threeDsServerTransId, this.eci, this.dsTransId, this.acsTransId, this.threeDsVersion, this.authenticationStatus);
        }

        public String toString() {
            return "PaymentAuthenticationRequest.PaymentAuthenticationRequestBuilder(type=" + this.type + ", cryptogram=" + this.cryptogram + ", threeDsServerTransId=" + this.threeDsServerTransId + ", eci=" + this.eci + ", dsTransId=" + this.dsTransId + ", acsTransId=" + this.acsTransId + ", threeDsVersion=" + this.threeDsVersion + ", authenticationStatus=" + this.authenticationStatus + ")";
        }
    }
}

