/*
 * Decompiled with CFR 0.152.
 */
package com.mercadopago.client.merchantorder;

import com.mercadopago.client.merchantorder.MerchantOrderItemRequest;
import com.mercadopago.client.merchantorder.MerchantOrderPayerRequest;
import com.mercadopago.client.merchantorder.MerchantOrderShipmentRequest;
import java.util.List;

public class MerchantOrderUpdateRequest {
    private final String siteId;
    private final MerchantOrderPayerRequest payer;
    private final String sponsorId;
    private final List<MerchantOrderItemRequest> items;
    private final List<MerchantOrderShipmentRequest> shipments;
    private final String notificationUrl;
    private final String additionalInfo;
    private final String externalReference;
    private final String marketplace;

    MerchantOrderUpdateRequest(String siteId, MerchantOrderPayerRequest payer, String sponsorId, List<MerchantOrderItemRequest> items, List<MerchantOrderShipmentRequest> shipments, String notificationUrl, String additionalInfo, String externalReference, String marketplace) {
        this.siteId = siteId;
        this.payer = payer;
        this.sponsorId = sponsorId;
        this.items = items;
        this.shipments = shipments;
        this.notificationUrl = notificationUrl;
        this.additionalInfo = additionalInfo;
        this.externalReference = externalReference;
        this.marketplace = marketplace;
    }

    public static MerchantOrderUpdateRequestBuilder builder() {
        return new MerchantOrderUpdateRequestBuilder();
    }

    public String getSiteId() {
        return this.siteId;
    }

    public MerchantOrderPayerRequest getPayer() {
        return this.payer;
    }

    public String getSponsorId() {
        return this.sponsorId;
    }

    public List<MerchantOrderItemRequest> getItems() {
        return this.items;
    }

    public List<MerchantOrderShipmentRequest> getShipments() {
        return this.shipments;
    }

    public String getNotificationUrl() {
        return this.notificationUrl;
    }

    public String getAdditionalInfo() {
        return this.additionalInfo;
    }

    public String getExternalReference() {
        return this.externalReference;
    }

    public String getMarketplace() {
        return this.marketplace;
    }

    public static class MerchantOrderUpdateRequestBuilder {
        private String siteId;
        private MerchantOrderPayerRequest payer;
        private String sponsorId;
        private List<MerchantOrderItemRequest> items;
        private List<MerchantOrderShipmentRequest> shipments;
        private String notificationUrl;
        private String additionalInfo;
        private String externalReference;
        private String marketplace;

        MerchantOrderUpdateRequestBuilder() {
        }

        public MerchantOrderUpdateRequestBuilder siteId(String siteId) {
            this.siteId = siteId;
            return this;
        }

        public MerchantOrderUpdateRequestBuilder payer(MerchantOrderPayerRequest payer) {
            this.payer = payer;
            return this;
        }

        public MerchantOrderUpdateRequestBuilder sponsorId(String sponsorId) {
            this.sponsorId = sponsorId;
            return this;
        }

        public MerchantOrderUpdateRequestBuilder items(List<MerchantOrderItemRequest> items) {
            this.items = items;
            return this;
        }

        public MerchantOrderUpdateRequestBuilder shipments(List<MerchantOrderShipmentRequest> shipments) {
            this.shipments = shipments;
            return this;
        }

        public MerchantOrderUpdateRequestBuilder notificationUrl(String notificationUrl) {
            this.notificationUrl = notificationUrl;
            return this;
        }

        public MerchantOrderUpdateRequestBuilder additionalInfo(String additionalInfo) {
            this.additionalInfo = additionalInfo;
            return this;
        }

        public MerchantOrderUpdateRequestBuilder externalReference(String externalReference) {
            this.externalReference = externalReference;
            return this;
        }

        public MerchantOrderUpdateRequestBuilder marketplace(String marketplace) {
            this.marketplace = marketplace;
            return this;
        }

        public MerchantOrderUpdateRequest build() {
            return new MerchantOrderUpdateRequest(this.siteId, this.payer, this.sponsorId, this.items, this.shipments, this.notificationUrl, this.additionalInfo, this.externalReference, this.marketplace);
        }

        public String toString() {
            return "MerchantOrderUpdateRequest.MerchantOrderUpdateRequestBuilder(siteId=" + this.siteId + ", payer=" + this.payer + ", sponsorId=" + this.sponsorId + ", items=" + this.items + ", shipments=" + this.shipments + ", notificationUrl=" + this.notificationUrl + ", additionalInfo=" + this.additionalInfo + ", externalReference=" + this.externalReference + ", marketplace=" + this.marketplace + ")";
        }
    }
}

