package com.melo.android.mvp.ui.loading;

import android.view.MotionEvent;
import android.view.View;

import com.melo.android.mvp.R;

public class Loading {

    private View main;
    private int mainLayoutId;

    public Loading(View view) {
        this(view, R.id.lyt_loading_main);
    }

    public Loading(View view, int mainLayoutId) {
        this.mainLayoutId = mainLayoutId;
        bind(view);
    }

    private void bind(View view) {
        main = view.findViewById(mainLayoutId);
        addListeners();
    }

    private void addListeners() {
        main.setOnTouchListener(new View.OnTouchListener() {
            @Override
            public boolean onTouch(View v, MotionEvent event) {
                return true;
            }
        });
    }

    public void show() {
        main.setVisibility(View.VISIBLE);
        main.bringToFront();
    }

    public void hide() {
        main.setVisibility(View.GONE);
    }
}
