/*
 * Decompiled with CFR 0.152.
 */
package com.melo.android.mvp.ui.fragment;

import android.content.Context;
import android.os.Bundle;
import android.support.annotation.Nullable;
import android.support.v4.app.Fragment;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Toast;
import com.melo.android.mvp.R;
import com.melo.android.mvp.business.IPresenter;
import com.melo.android.mvp.event.IEvent;
import com.melo.android.mvp.ui.fragment.IView;
import com.melo.android.mvp.ui.loading.Loading;
import java.util.HashMap;
import java.util.Map;
import org.greenrobot.eventbus.EventBus;

public abstract class MFragment<P extends IPresenter>
extends Fragment
implements IView {
    protected P presenter;
    private Map<Integer, Loading> mapLoadings;

    protected abstract int getLayoutId();

    protected abstract P createPresenter();

    protected abstract Integer[] getLoadingsLayoutsIds();

    public void onAttach(Context context) {
        super.onAttach(context);
        if (this.presenter != null) {
            return;
        }
        this.presenter = this.createPresenter();
    }

    @Nullable
    public View onCreateView(LayoutInflater inflater, @Nullable ViewGroup container, Bundle savedInstanceState) {
        this.mapLoadings = new HashMap<Integer, Loading>();
        if (this.isPresenterEvent() && !EventBus.getDefault().isRegistered(this.presenter)) {
            EventBus.getDefault().register(this.presenter);
        }
        this.presenter.setView((MFragment)this);
        return inflater.inflate(this.getLayoutId(), container, false);
    }

    public void onViewCreated(View view, @Nullable Bundle savedInstanceState) {
        super.onViewCreated(view, savedInstanceState);
        this.createLoadingOptions(view);
    }

    public void onStart() {
        super.onStart();
        this.presenter.onStart();
    }

    public void onStop() {
        this.presenter.onStop();
        super.onStop();
    }

    public void onDestroyView() {
        if (this.isPresenterEvent()) {
            EventBus.getDefault().unregister(this.presenter);
        }
        this.presenter.setView(null);
        super.onDestroyView();
    }

    private void createLoadingOptions(View view) {
        this.createLoadingIfExists(view, R.id.lyt_loading_main);
        Integer[] idsLoadings = this.getLoadingsLayoutsIds();
        if (idsLoadings == null) {
            return;
        }
        for (Integer idLoading : idsLoadings) {
            this.createLoadingIfExists(view, idLoading);
        }
    }

    private void createLoadingIfExists(View view, Integer idLoading) {
        if (view.findViewById(idLoading.intValue()) == null) {
            return;
        }
        if (this.mapLoadings.containsKey(idLoading)) {
            return;
        }
        this.mapLoadings.put(idLoading, new Loading(view, idLoading));
    }

    @Override
    public void showToast(String message) {
        Toast.makeText((Context)this.getActivity(), (CharSequence)message, (int)0).show();
    }

    @Override
    public void showToast(int message) {
        Toast.makeText((Context)this.getActivity(), (int)message, (int)0).show();
    }

    private boolean isPresenterEvent() {
        return IEvent.class.isAssignableFrom(this.presenter.getClass());
    }

    @Override
    public void showLoading() {
        this.showLoading(R.id.lyt_loading_main);
    }

    @Override
    public void hideLoading() {
        this.hideLoading(R.id.lyt_loading_main);
    }

    @Override
    public void showLoading(int id2) {
        this.mapLoadings.get(id2).show();
    }

    @Override
    public void hideLoading(int id2) {
        this.mapLoadings.get(id2).hide();
    }
}

