package com.melo.android.mvp.business;

import android.util.Log;

import com.melo.android.mvp.ui.fragment.IView;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;

public abstract class Presenter<V extends IView> implements IPresenter<V> {

    private V original;
    private V proxy;

    private final Handler handler;

    public Presenter(V original) {
        this.original = original;
        this.handler = new Handler(original);

        proxy = (V) Proxy.newProxyInstance(original.getClass().getClassLoader(),
                new Class[] { original.getClass() },
                handler);
    }

    @Override
    public void setView(V view) {
        original = view;
    }

    @Override
    public V getView() {
        if (proxy != null) return proxy;

        Log.e(getClass().getName(), "there are some problems because is returning the original view");

        return original;
    }

    private class Handler implements InvocationHandler {
        private final V original;

        public Handler(V original) {
            this.original = original;
        }

        public Object invoke(Object proxy, Method method, Object[] args) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
            Log.d(getClass().getName(), "passing through proxy view");

            if (original != null)
                return method.invoke(original, args);

            Log.w(getClass().getName(), "view is null so just ignore the call");

            return null;
        }
    }
}
