/*
 * Decompiled with CFR 0.152.
 */
package com.melo.android.mvp.business;

import android.util.Log;
import com.melo.android.mvp.business.IPresenter;
import com.melo.android.mvp.ui.fragment.IView;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;

public abstract class Presenter<V extends IView>
implements IPresenter<V> {
    private V original;
    private V proxy;
    private final Handler handler;

    public Presenter(V original) {
        this.original = original;
        this.handler = new Handler(this, original);
        Class iView = this.getIView();
        this.proxy = (IView)Proxy.newProxyInstance(iView.getClassLoader(), new Class[]{iView}, (InvocationHandler)this.handler);
    }

    private Class getIView() {
        Class<?>[] interfaces;
        for (Class<?> clazz : interfaces = this.original.getClass().getInterfaces()) {
            if (!IView.class.isAssignableFrom(clazz)) continue;
            return clazz;
        }
        throw new UnsupportedOperationException("Interce IView not found in fragment");
    }

    @Override
    public void setView(V view) {
        this.original = view;
    }

    @Override
    public V getView() {
        if (this.proxy != null) {
            return this.proxy;
        }
        Log.e((String)this.getClass().getName(), (String)"there are some problems because is returning the original view");
        return this.original;
    }

    private static class Handler
    implements InvocationHandler {
        private final V original;
        final /* synthetic */ Presenter this$0;

        public Handler(V original) {
            this.this$0 = var1_1;
            this.original = original;
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
            if (this.original != null) {
                try {
                    return method.invoke(this.original, args);
                }
                catch (NullPointerException | InvocationTargetException e) {
                    Log.e((String)this.getClass().getName(), (String)("fail to call method through proxy " + e.getMessage()));
                }
            }
            Log.w((String)this.getClass().getName(), (String)"view is null so just ignore the call");
            return null;
        }
    }
}

