/*
 * Decompiled with CFR 0.152.
 */
package com.mediatek.mcs.push;

import android.content.Context;
import android.os.AsyncTask;
import android.text.TextUtils;
import com.google.android.gms.gcm.GoogleCloudMessaging;
import com.mediatek.mcs.Mcs;
import com.mediatek.mcs.McsLog;
import com.mediatek.mcs.push.GcmPreference;
import java.io.IOException;

public class PushRegistration {
    private Context context = Mcs.getApplicationContext();
    private OnPushRegisteredListener onPushRegisteredListener;

    public PushRegistration(String gcmSenderId, OnPushRegisteredListener listener) {
        this.onPushRegisteredListener = listener;
        String regId = GcmPreference.getInstance().getRegistrationId(this.context);
        if (TextUtils.isEmpty((CharSequence)regId)) {
            this.registerInBackground(gcmSenderId);
        } else {
            this.onPushRegisteredListener.onSuccess(regId, GcmPreference.getInstance().isUpdateRegId());
        }
    }

    private void registerInBackground(final String gcm_sender_id) {
        new AsyncTask<Void, Void, String>(){

            protected String doInBackground(Void ... params) {
                String msg = "";
                try {
                    String mRegId = GoogleCloudMessaging.getInstance((Context)PushRegistration.this.context).register(new String[]{gcm_sender_id});
                    msg = "Device registered, registration ID = " + mRegId;
                    GcmPreference.getInstance().storeRegistrationId(PushRegistration.this.context, mRegId);
                    PushRegistration.this.onPushRegisteredListener.onSuccess(mRegId, GcmPreference.getInstance().isUpdateRegId());
                }
                catch (IOException ex) {
                    msg = "Failed to Register GCM. Error :" + ex.getMessage();
                    McsLog.e(new IOException(msg, ex), new Object[0]);
                }
                McsLog.d("GCM register msg: " + msg, new Object[0]);
                return msg;
            }
        }.execute((Object[])new Void[]{null, null, null});
    }

    public static interface OnPushRegisteredListener {
        public void onSuccess(String var1, boolean var2);
    }
}

