/*
 * Decompiled with CFR 0.152.
 */
package com.mediatek.mcs.push;

import android.content.Context;
import android.content.SharedPreferences;
import android.content.pm.PackageManager;
import com.mediatek.mcs.Mcs;
import com.mediatek.mcs.McsLog;
import com.mediatek.mcs.push.PushRegistration;

public class GcmPreference {
    public static final String PROPERTY_REG_ID = "registration_id";
    private static final String PROPERTY_APP_VERSION = "appVersion";
    private static GcmPreference instance = null;
    boolean isUpdateRegId = false;

    GcmPreference() {
    }

    public static synchronized GcmPreference getInstance() {
        if (instance == null) {
            instance = new GcmPreference();
        }
        return instance;
    }

    public boolean isUpdateRegId() {
        return this.isUpdateRegId;
    }

    public String getRegistrationId(Context context) {
        SharedPreferences prefs = this.getGcmPreferences(context);
        String registrationId = prefs.getString(PROPERTY_REG_ID, "");
        if (registrationId.isEmpty()) {
            McsLog.d("Registration not found.", new Object[0]);
            return "";
        }
        int registeredVersion = prefs.getInt(PROPERTY_APP_VERSION, Integer.MIN_VALUE);
        if (registeredVersion != this.getCurrentVersion()) {
            McsLog.d("App version changed.", new Object[0]);
            this.isUpdateRegId = true;
            return "";
        }
        return registrationId;
    }

    public void storeRegistrationId(Context context, String regId) {
        SharedPreferences prefs = this.getGcmPreferences(context);
        SharedPreferences.Editor editor = prefs.edit();
        editor.putString(PROPERTY_REG_ID, regId);
        editor.putInt(PROPERTY_APP_VERSION, this.getCurrentVersion());
        editor.commit();
    }

    private SharedPreferences getGcmPreferences(Context context) {
        return context.getSharedPreferences(PushRegistration.class.getSimpleName(), 0);
    }

    private int getCurrentVersion() {
        try {
            return Mcs.getApplicationContext().getPackageManager().getPackageInfo((String)Mcs.getApplicationContext().getPackageName(), (int)0).versionCode;
        }
        catch (PackageManager.NameNotFoundException e) {
            return 1;
        }
    }
}

