/*
 * Decompiled with CFR 0.152.
 */
package com.mediatek.mcs.net;

import com.android.volley.AuthFailureError;
import com.android.volley.Cache;
import com.android.volley.NetworkResponse;
import com.android.volley.ParseError;
import com.android.volley.Request;
import com.android.volley.Response;
import com.android.volley.VolleyError;
import com.android.volley.toolbox.HttpHeaderParser;
import com.mediatek.mcs.domain.McsResponse;
import com.mediatek.mcs.domain.McsSession;
import com.mediatek.mcs.net.McsRequestHelper;
import com.mediatek.mcs.net.RequestErrorListener;
import java.io.UnsupportedEncodingException;
import java.util.HashMap;
import java.util.Map;
import org.json.JSONException;
import org.json.JSONObject;

public class SignInRequest
extends Request<JSONObject> {
    private McsResponse.SuccessListener<JSONObject> listener;
    private Map<String, String> params;

    public SignInRequest(int method, String url, Map<String, String> params, McsResponse.SuccessListener<JSONObject> listener) {
        this(method, url, params, listener, new RequestErrorListener());
    }

    public SignInRequest(int method, String url, Map<String, String> params, McsResponse.SuccessListener<JSONObject> listener, McsResponse.ErrorListener errorListener) {
        super(method, url, McsRequestHelper.transformErrorListener(errorListener));
        this.params = params;
        this.listener = listener;
    }

    public static Map<String, String> getSignInParams() {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("email", McsSession.getInstance().getCurrentUser().getEmail());
        params.put("password", McsSession.getInstance().getCurrentUser().getPassword());
        params.put("secret_key", "Zm9vU2VjcmV0");
        return params;
    }

    public static Map<String, String> getSignInParams(String refreshToken) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("token", refreshToken);
        return params;
    }

    protected Map<String, String> getParams() {
        return this.params;
    }

    public Map<String, String> getHeaders() throws AuthFailureError {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("Content-Type", "application/x-www-form-urlencoded");
        return params;
    }

    protected Response<JSONObject> parseNetworkResponse(NetworkResponse response) {
        try {
            String jsonString = new String(response.data, HttpHeaderParser.parseCharset((Map)response.headers));
            return Response.success((Object)new JSONObject(jsonString), (Cache.Entry)HttpHeaderParser.parseCacheHeaders((NetworkResponse)response));
        }
        catch (UnsupportedEncodingException e) {
            return Response.error((VolleyError)new ParseError((Throwable)e));
        }
        catch (JSONException je) {
            return Response.error((VolleyError)new ParseError((Throwable)je));
        }
    }

    protected void deliverResponse(JSONObject response) {
        this.listener.onSuccess(response);
    }
}

