/*
 * Decompiled with CFR 0.152.
 */
package com.mediatek.mcs.net;

import android.os.Process;
import com.android.volley.AuthFailureError;
import com.android.volley.NetworkResponse;
import com.android.volley.Request;
import com.android.volley.VolleyError;
import com.android.volley.toolbox.JsonObjectRequest;
import com.google.gson.Gson;
import com.mediatek.mcs.McsLog;
import com.mediatek.mcs.R;
import com.mediatek.mcs.Utils.UIUtils;
import com.mediatek.mcs.domain.McsResponse;
import com.mediatek.mcs.domain.McsSession;
import com.mediatek.mcs.entity.AuthEntity;
import com.mediatek.mcs.net.AuthedJsonRequest$$Lambda$1;
import com.mediatek.mcs.net.AuthedJsonRequest$$Lambda$2;
import com.mediatek.mcs.net.McsRequestHelper;
import com.mediatek.mcs.net.RequestApi;
import com.mediatek.mcs.net.RequestManager;
import com.mediatek.mcs.net.RequestUtils;
import com.mediatek.mcs.net.SignInRequest;
import java.util.Map;
import org.json.JSONObject;

public class AuthedJsonRequest
extends JsonObjectRequest {
    McsResponse.ErrorListener authTokenErrorListener = AuthedJsonRequest$$Lambda$1.lambdaFactory$(this);
    private int method;
    private String url;
    private Map<String, String> headers;
    private String requestBody;
    private McsResponse.SuccessListener<JSONObject> listener;
    private McsResponse.ErrorListener errorListener;

    public AuthedJsonRequest(int method, String url, Map<String, String> headers, String requestBody, McsResponse.SuccessListener<JSONObject> listener, McsResponse.ErrorListener errorListener) {
        super(method, url, requestBody, McsRequestHelper.transformListener(listener), McsRequestHelper.transformErrorListener(errorListener));
        this.headers = headers;
        this.initRequest(method, url, headers, requestBody, listener, errorListener);
    }

    public Map<String, String> getHeaders() throws AuthFailureError {
        return RequestUtils.putAuthHeader(this.headers);
    }

    private void initRequest(int method, String url, Map<String, String> headers, String requestBody, McsResponse.SuccessListener<JSONObject> listener, McsResponse.ErrorListener errorListener) {
        this.method = method;
        this.url = url;
        this.headers = headers;
        this.requestBody = requestBody;
        this.listener = listener;
        this.errorListener = errorListener;
    }

    public void deliverError(VolleyError error) {
        if (this.isTokenExpired(error)) {
            this.requestAccessToken();
        } else {
            super.deliverError(error);
        }
    }

    public boolean isTokenExpired(VolleyError error) {
        NetworkResponse networkResponse = error.networkResponse;
        return networkResponse != null && networkResponse.statusCode == 401;
    }

    private void requestAccessToken() {
        RequestManager.sendInBackground(new SignInRequest(1, RequestApi.REFRESH_ACCESS_TOKEN, SignInRequest.getSignInParams(McsSession.getInstance().getCurrentUser().getToken()), AuthedJsonRequest$$Lambda$2.lambdaFactory$(this), this.authTokenErrorListener));
    }

    private void resendRequest() {
        RequestManager.sendInBackground((Request)new AuthedJsonRequest(this.method, this.url, this.headers, this.requestBody, this.listener, this.errorListener));
    }

    private void logMeOut() {
        McsSession.getInstance().getCurrentUser().clearPref();
        Process.killProcess((int)Process.myPid());
    }

    private /* synthetic */ void lambda$requestAccessToken$5(JSONObject response) {
        McsSession.getInstance().saveTokenResultsToPref(((AuthEntity.AccessToken)new Gson().fromJson(response.toString(), AuthEntity.AccessToken.class)).getResults());
        this.resendRequest();
    }

    private /* synthetic */ void lambda$new$4(Exception error) {
        McsLog.e(error, new Object[0]);
        if (this.isTokenExpired((VolleyError)error)) {
            UIUtils.toast(R.string.error_token_expired);
            this.logMeOut();
        } else {
            UIUtils.toast(RequestUtils.parseMcsNetworkError(error));
        }
    }

    static /* synthetic */ void access$lambda$0(AuthedJsonRequest authedJsonRequest, Exception exception) {
        authedJsonRequest.lambda$new$4(exception);
    }

    static /* synthetic */ void access$lambda$1(AuthedJsonRequest authedJsonRequest, JSONObject jSONObject) {
        authedJsonRequest.lambda$requestAccessToken$5(jSONObject);
    }
}

