package com.mediatek.mcs.pref;

import android.content.SharedPreferences.Editor;
import com.mediatek.mcs.entity.McsUserInfoEntity;
import lombok.Getter;
import lombok.Setter;
import org.json.JSONObject;

public final class McsUserInfo implements McsPreferences {
  @Getter @Setter private String userImageURL;
  @Getter @Setter private String nickname;

  final String USER_INFO_NICKNAME = "USER_INFO_NICKNAME";
  final String USER_INFO_IMAGE_URL = "USER_INFO_IMAGE_URL";
  private static McsUserInfo INSTANCE = new McsUserInfo();

  private McsUserInfo() {
    this.nickname = pref.getString(USER_INFO_NICKNAME, "");
    this.userImageURL = pref.getString(USER_INFO_IMAGE_URL, "");
  }

  public static McsUserInfo getInstance() {
    return INSTANCE;
  }

  public void clearPref() {
    this.nickname = "";
    this.userImageURL = "";
    savePref();
  }

  public void savePref() {
    Editor editor = pref.edit();
    editor.putString(USER_INFO_NICKNAME, this.nickname);
    editor.putString(USER_INFO_IMAGE_URL, this.userImageURL);
    editor.commit();
  }

  public void saveToPref(JSONObject response) {
    saveUserInfo(gson.fromJson(response.toString(), McsUserInfoEntity.class));
  }

  private void saveUserInfo(McsUserInfoEntity info) {
    this.setNickname(info.getNickname());
    this.setUserImageURL(info.getUserImageURL());
    this.savePref();
  }
}
