package com.mediatek.mcs.pref;

import android.content.SharedPreferences.Editor;
import com.mediatek.mcs.entity.AuthEntity;
import lombok.Getter;
import lombok.Setter;
import org.json.JSONObject;

/**
 * Notice: token is different from access_token.
 */
public final class McsUser implements McsPreferences {
  @Getter @Setter private String email;
  @Getter @Setter private String password;
  @Getter @Setter private String token;
  @Getter @Setter private String accessToken;
  @Getter @Setter private boolean isRememberMe;

  final String USER_EMAIL = "USER_EMAIL";
  final String USER_PASSWORD = "USER_PASSWORD";
  final String USER_TOKEN = "USER_TOKEN";
  final String USER_ACCESS_TOKEN = "USER_ACCESS_TOKEN";
  final String USER_REMEMBER_ME = "USER_REMEMBER_ME";
  private static McsUser INSTANCE = new McsUser();

  private McsUser() {
    this.email = pref.getString(USER_EMAIL, "");
    this.password = pref.getString(USER_PASSWORD, "");
    this.token = pref.getString(USER_TOKEN, "");
    this.accessToken = pref.getString(USER_ACCESS_TOKEN, "");
    this.isRememberMe = pref.getBoolean(USER_REMEMBER_ME, false);
  }

  public static McsUser getInstance() {
    return INSTANCE;
  }

  public void clearPref() {
    this.email = "";
    this.password = "";
    this.isRememberMe = false;
    this.token = "";
    this.accessToken = "";
    savePref();
  }

  public void savePref() {
    Editor editor = pref.edit();
    editor.putString(USER_EMAIL, this.email);
    editor.putString(USER_PASSWORD, this.password);
    editor.putString(USER_TOKEN, this.token);
    editor.putString(USER_ACCESS_TOKEN, this.accessToken);
    editor.putBoolean(USER_REMEMBER_ME, this.isRememberMe);
    editor.commit();
  }

  public void saveToPref(JSONObject response) {
    saveUser(gson.fromJson(response.toString(), AuthEntity.Token.class));
  }

  private void saveUser(AuthEntity.Token auth) {
    this.setToken(auth.getToken());
    this.setAccessToken(auth.getAccessToken());
    this.savePref();
  }
}
