package com.mediatek.mcs.entity.api;

import com.mediatek.mcs.net.RequestApi;
import lombok.AccessLevel;
import lombok.Getter;

/**
 * Model of results of DEVICES
 */
@Getter public class DeviceSummaryEntity extends ApiResults<DeviceSummaryEntity> {
  private String deviceId;
  private String name;
  private String prodName;
  private String prodVersion;
  private String description;
  private String privilege;
  @Getter(AccessLevel.NONE) private String deviceImageURL;
  private boolean isHeartbeating;
  private boolean isActive;
  private boolean isTest;

  public String getDeviceImageURL() {
    return ("productBanner.jpg".equals(deviceImageURL) || "".equals(deviceImageURL)) ? ""
        : RequestApi.getImageServerPrefix() + deviceImageURL;
  }
}
