package com.mediatek.mcs.domain;

import com.mediatek.mcs.R;
import com.mediatek.mcs.entity.DataPointEntity;
import com.mediatek.mcs.exception.InvalidDataPointException;
import lombok.Getter;

@Getter public class McsGeoPoint {
  private double latitude;
  private double longitude;
  private double altitude;

  public McsGeoPoint(DataPointEntity.Values values) throws InvalidDataPointException {
    this(Double.toString(values.getLatitude()),
        Double.toString(values.getLongitude()),
        Double.toString(values.getAltitude()));
  }

  public McsGeoPoint(String latString, String lngString, String altString)
      throws InvalidDataPointException {

    if ("".equals(latString) || "".equals(lngString)) {
      throw new InvalidDataPointException(R.string.error_invalid_upload_value);
    }

    if ("".equals(altString)) {
      altString = "0";
    }

    try {
      float latitude = Float.parseFloat(latString);
      float longitude = Float.parseFloat(lngString);
      float altitude = Float.parseFloat(altString);

      if(-180.0d <= longitude && longitude < 180.0d) {
        this.longitude = longitude;
      } else {
        this.longitude = ((longitude - 180.0d) % 360.0d + 360.0d) % 360.0d - 180.0d;
      }

      this.latitude = Math.max(-90.0d, Math.min(90.0d, latitude));
      this.altitude = altitude;

    } catch (NumberFormatException e) {
      throw new InvalidDataPointException(R.string.error_invalid_upload_dp, e);
    }
  }

  public McsGeoPoint trim() throws InvalidDataPointException {
    this.latitude = Double.parseDouble(DataPointFormatter.trimGeoValue(latitude));
    this.longitude = Double.parseDouble(DataPointFormatter.trimGeoValue(longitude));
    this.altitude = Double.parseDouble(DataPointFormatter.trimGeoValue(altitude));

    return this;
  }
}
