/*
 * Decompiled with CFR 0.152.
 */
package com.mediatek.mcs.push;

import android.text.TextUtils;
import com.android.volley.Request;
import com.google.android.gms.common.GoogleApiAvailability;
import com.mediatek.mcs.Mcs;
import com.mediatek.mcs.McsLog;
import com.mediatek.mcs.R;
import com.mediatek.mcs.Utils.ResponseMessage;
import com.mediatek.mcs.domain.McsResponse;
import com.mediatek.mcs.exception.SdkInstallationException;
import com.mediatek.mcs.net.McsJsonRequest;
import com.mediatek.mcs.net.RequestApi;
import com.mediatek.mcs.net.RequestManager;
import com.mediatek.mcs.net.RequestUtils;
import com.mediatek.mcs.pref.McsMobile;
import com.mediatek.mcs.push.McsPushInstallation$$Lambda$1;
import com.mediatek.mcs.push.McsPushInstallation$$Lambda$2;
import com.mediatek.mcs.push.McsPushInstallation$$Lambda$3;
import com.mediatek.mcs.push.McsPushInstallation$$Lambda$4;
import com.mediatek.mcs.push.McsPushInstallation$$Lambda$5;
import com.mediatek.mcs.push.McsPushInstallation$$Lambda$6;
import com.mediatek.mcs.push.McsPushInstallation$$Lambda$7;
import com.mediatek.mcs.push.McsPushInstallation$$Lambda$8;
import com.mediatek.mcs.push.McsPushInstallation$$Lambda$9;
import com.mediatek.mcs.push.McsRegisterMobile;
import com.mediatek.mcs.push.PushRegistration;
import org.json.JSONObject;

public final class McsPushInstallation {
    private static McsPushInstallation INSTANCE = new McsPushInstallation();
    private String gcmSenderId = "";
    private String appKey = "";
    private String regId = "";
    private boolean isUpdateRegId = false;

    private McsPushInstallation() {
    }

    public static McsPushInstallation getInstance() {
        return INSTANCE;
    }

    public void registerInBackground(String gcm_sender_id, String gcm_api_key, McsResponse.SuccessListener<JSONObject> successListener, McsResponse.ErrorListener errorListener) {
        if (!this.isValidInstall(gcm_sender_id, gcm_api_key)) {
            return;
        }
        this.gcmSenderId = gcm_sender_id;
        this.appKey = gcm_api_key;
        new PushRegistration(this.gcmSenderId, McsPushInstallation$$Lambda$1.lambdaFactory$(this, successListener, errorListener));
    }

    public void registerInBackground(String gcm_sender_id, String gcm_api_key) {
        this.registerInBackground(gcm_sender_id, gcm_api_key, McsPushInstallation$$Lambda$2.lambdaFactory$(), McsPushInstallation$$Lambda$3.lambdaFactory$());
    }

    boolean isValidInstall(String gcmSenderId, String appKey) {
        if (Mcs.getApplicationContext() == null) {
            McsLog.e(new SdkInstallationException(R.string.error_install_not_init), new Object[0]);
            return false;
        }
        int playServiceResult = GoogleApiAvailability.getInstance().isGooglePlayServicesAvailable(Mcs.getApplicationContext());
        if (playServiceResult != 0) {
            McsLog.e(new SdkInstallationException(Mcs.getApplicationContext().getString(R.string.error_install_no_google_play) + "\nplayServiceResult errorCode: " + playServiceResult), new Object[0]);
            return false;
        }
        if (TextUtils.isEmpty((CharSequence)gcmSenderId) || TextUtils.isEmpty((CharSequence)appKey)) {
            McsLog.e(new SdkInstallationException(R.string.error_install_push_gcm_invalid), new Object[0]);
            return false;
        }
        return true;
    }

    public boolean isPushInstalled() {
        return !TextUtils.isEmpty((CharSequence)this.gcmSenderId) && !TextUtils.isEmpty((CharSequence)this.appKey);
    }

    public void requestRegisterMobile(McsResponse.SuccessListener<JSONObject> successListener, McsResponse.ErrorListener errorListener) {
        String url;
        int method;
        String responseAction;
        if (TextUtils.isEmpty((CharSequence)this.regId)) {
            this.registerInBackground(this.gcmSenderId, this.appKey);
            errorListener.onError(new SdkInstallationException(R.string.error_install_push_reg_token_empty));
            return;
        }
        if (this.isUpdateRegId) {
            responseAction = "Update mobile";
            method = 2;
            url = RequestApi.MOBILE.replace("{mobileId}", McsMobile.getInstance().getMobileId());
        } else {
            responseAction = "Register mobile";
            method = 1;
            url = RequestApi.MOBILES;
        }
        String finalResponseAction = responseAction;
        RequestManager.sendInBackground((Request)new McsJsonRequest(method, url, new McsRegisterMobile(this.regId, this.appKey).toString(), McsPushInstallation$$Lambda$4.lambdaFactory$(this, successListener, finalResponseAction), McsPushInstallation$$Lambda$5.lambdaFactory$(errorListener)));
    }

    public void requestUnRegisterMobile() {
        if (TextUtils.isEmpty((CharSequence)McsMobile.getInstance().getMobileId())) {
            McsLog.e("mobileId is empty, still sign out.", new Object[0]);
            return;
        }
        RequestManager.sendInBackground((Request)new McsJsonRequest(3, RequestApi.MOBILE.replace("{mobileId}", McsMobile.getInstance().getMobileId()), McsPushInstallation$$Lambda$6.lambdaFactory$(), McsPushInstallation$$Lambda$7.lambdaFactory$()));
    }

    public String getGcmSenderId() {
        return this.gcmSenderId;
    }

    public String getAppKey() {
        return this.appKey;
    }

    public void setAppKey(String appKey) {
        this.appKey = appKey;
    }

    public String getRegId() {
        return this.regId;
    }

    public void setRegId(String regId) {
        this.regId = regId;
    }

    public boolean isUpdateRegId() {
        return this.isUpdateRegId;
    }

    public void setUpdateRegId(boolean isUpdateRegId) {
        this.isUpdateRegId = isUpdateRegId;
    }

    private static /* synthetic */ void lambda$requestUnRegisterMobile$17(Exception error) {
        McsLog.e("Unexpected error: " + error.toString(), new Object[0]);
    }

    private static /* synthetic */ void lambda$requestUnRegisterMobile$16(JSONObject response) {
        McsMobile.getInstance().clearPref();
        McsLog.d("mobile unregistered.", new Object[0]);
    }

    private /* synthetic */ void lambda$requestRegisterMobile$14(McsResponse.SuccessListener successListener, String string2, JSONObject response) {
        if (!this.isUpdateRegId) {
            McsMobile.getInstance().saveToPref(response);
        }
        successListener.onSuccess(ResponseMessage.create(string2 + " succeeded."));
    }

    private static /* synthetic */ void lambda$registerInBackground$13(Exception error) {
        McsLog.e(error.toString(), new Object[0]);
    }

    private static /* synthetic */ void lambda$registerInBackground$12(JSONObject response) {
        McsLog.d(response.toString(), new Object[0]);
    }

    private /* synthetic */ void lambda$registerInBackground$11(McsResponse.SuccessListener successListener, McsResponse.ErrorListener errorListener, String regId, boolean isUpdateRegId) {
        this.regId = regId;
        this.isUpdateRegId = isUpdateRegId;
        McsLog.d("Gcm installed successfully", new Object[0]);
        McsPushInstallation mcsPushInstallation = McsPushInstallation.getInstance();
        McsResponse.SuccessListener successListener2 = successListener;
        successListener2.getClass();
        McsResponse.SuccessListener successListener3 = McsPushInstallation$$Lambda$8.lambdaFactory$(successListener2);
        McsResponse.ErrorListener errorListener2 = errorListener;
        errorListener2.getClass();
        mcsPushInstallation.requestRegisterMobile(successListener3, McsPushInstallation$$Lambda$9.lambdaFactory$(errorListener2));
    }

    static /* synthetic */ void access$lambda$0(McsPushInstallation mcsPushInstallation, McsResponse.SuccessListener successListener, McsResponse.ErrorListener errorListener, String string2, boolean bl) {
        mcsPushInstallation.lambda$registerInBackground$11(successListener, errorListener, string2, bl);
    }

    static /* synthetic */ void access$lambda$1(JSONObject jSONObject) {
        McsPushInstallation.lambda$registerInBackground$12(jSONObject);
    }

    static /* synthetic */ void access$lambda$2(Exception exception) {
        McsPushInstallation.lambda$registerInBackground$13(exception);
    }

    static /* synthetic */ void access$lambda$3(McsPushInstallation mcsPushInstallation, McsResponse.SuccessListener successListener, String string2, JSONObject jSONObject) {
        mcsPushInstallation.lambda$requestRegisterMobile$14(successListener, string2, jSONObject);
    }

    static /* synthetic */ void access$lambda$4(McsResponse.ErrorListener errorListener, Exception exception) {
        errorListener.onError(RequestUtils.parseVolleyError(exception));
    }

    static /* synthetic */ void access$lambda$5(JSONObject jSONObject) {
        McsPushInstallation.lambda$requestUnRegisterMobile$16(jSONObject);
    }

    static /* synthetic */ void access$lambda$6(Exception exception) {
        McsPushInstallation.lambda$requestUnRegisterMobile$17(exception);
    }
}

