/*
 * Decompiled with CFR 0.152.
 */
package com.mediatek.mcs.pref;

import android.content.SharedPreferences;
import com.mediatek.mcs.entity.AuthEntity;
import com.mediatek.mcs.pref.McsPreferences;
import org.json.JSONObject;

public final class McsUser
implements McsPreferences {
    private String email = pref.getString("USER_EMAIL", "");
    private String password = pref.getString("USER_PASSWORD", "");
    private String token = pref.getString("USER_TOKEN", "");
    private String accessToken = pref.getString("USER_ACCESS_TOKEN", "");
    private boolean isRememberMe = pref.getBoolean("USER_REMEMBER_ME", false);
    final String USER_EMAIL = "USER_EMAIL";
    final String USER_PASSWORD = "USER_PASSWORD";
    final String USER_TOKEN = "USER_TOKEN";
    final String USER_ACCESS_TOKEN = "USER_ACCESS_TOKEN";
    final String USER_REMEMBER_ME = "USER_REMEMBER_ME";
    private static McsUser INSTANCE = new McsUser();

    private McsUser() {
    }

    public static McsUser getInstance() {
        return INSTANCE;
    }

    @Override
    public void clearPref() {
        this.email = "";
        this.password = "";
        this.isRememberMe = false;
        this.token = "";
        this.accessToken = "";
        this.savePref();
    }

    @Override
    public void savePref() {
        SharedPreferences.Editor editor = pref.edit();
        editor.putString("USER_EMAIL", this.email);
        editor.putString("USER_PASSWORD", this.password);
        editor.putString("USER_TOKEN", this.token);
        editor.putString("USER_ACCESS_TOKEN", this.accessToken);
        editor.putBoolean("USER_REMEMBER_ME", this.isRememberMe);
        editor.commit();
    }

    public void saveToPref(JSONObject response) {
        this.saveUser((AuthEntity.Token)gson.fromJson(response.toString(), AuthEntity.Token.class));
    }

    private void saveUser(AuthEntity.Token auth) {
        this.setToken(auth.getToken());
        this.setAccessToken(auth.getAccessToken());
        this.savePref();
    }

    public String getEmail() {
        return this.email;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getToken() {
        return this.token;
    }

    public void setToken(String token) {
        this.token = token;
    }

    public String getAccessToken() {
        return this.accessToken;
    }

    public void setAccessToken(String accessToken) {
        this.accessToken = accessToken;
    }

    public boolean isRememberMe() {
        return this.isRememberMe;
    }

    public void setRememberMe(boolean isRememberMe) {
        this.isRememberMe = isRememberMe;
    }
}

