/*
 * Decompiled with CFR 0.152.
 */
package com.mediatek.mcs.domain;

import com.android.volley.Request;
import com.google.gson.Gson;
import com.mediatek.mcs.McsLog;
import com.mediatek.mcs.Utils.UIUtils;
import com.mediatek.mcs.domain.DataPointFormatter;
import com.mediatek.mcs.domain.McsDataChannel$$Lambda$1;
import com.mediatek.mcs.domain.McsDataChannel$$Lambda$2;
import com.mediatek.mcs.domain.McsDataChannel$$Lambda$3;
import com.mediatek.mcs.entity.DataChannelEntity;
import com.mediatek.mcs.entity.DataPointEntity;
import com.mediatek.mcs.entity.DataPointsUploadEntity;
import com.mediatek.mcs.entity.api.DeviceInfoEntity;
import com.mediatek.mcs.event.DataPointEvent;
import com.mediatek.mcs.exception.InvalidDataPointException;
import com.mediatek.mcs.net.McsJsonRequest;
import com.mediatek.mcs.net.RequestApi;
import com.mediatek.mcs.net.RequestManager;
import com.mediatek.mcs.socket.McsSocketListener;
import de.greenrobot.event.EventBus;
import org.json.JSONException;
import org.json.JSONObject;

public class McsDataChannel {
    String deviceId;
    String deviceKey;
    DataChannelEntity dataChannelEntity;
    McsSocketListener mcsSocketListener;

    public McsDataChannel(DeviceInfoEntity device, DataChannelEntity channelEntity, McsSocketListener listener) {
        this.deviceId = device.getDeviceId();
        this.deviceKey = device.getDeviceKey();
        this.dataChannelEntity = channelEntity;
        this.mcsSocketListener = listener;
    }

    public McsDataChannel(DeviceInfoEntity device, DataChannelEntity channelEntity) {
        this(device, channelEntity, null);
        this.mcsSocketListener = new McsSocketListener(McsDataChannel$$Lambda$1.lambdaFactory$(this));
    }

    public String getChannelId() {
        return this.dataChannelEntity.getDataChnId();
    }

    public String getChannelName() {
        return this.dataChannelEntity.getName();
    }

    public boolean isControllable() {
        return this.dataChannelEntity.isControllable();
    }

    public DataPointEntity getDataPointEntity() {
        return this.dataChannelEntity.getDataPoint();
    }

    public void setDataPointEntity(DataPointEntity dp) {
        if (dp != null) {
            this.dataChannelEntity.setDataPoint(dp);
            EventBus.getDefault().post((Object)new DataPointEvent(this.getChannelId(), dp));
        }
    }

    public void submitDataPoint(DataPointEntity.Values values) {
        try {
            DataPointEntity.Values formattedValues = DataPointFormatter.formatValues(this.getDataChannelEntity(), values);
            String body = new Gson().toJson((Object)new DataPointsUploadEntity(new DataPointsUploadEntity.DataPoint(this.getChannelId(), formattedValues)));
            this.requestUploadDataPointForBase(body);
        }
        catch (InvalidDataPointException e) {
            UIUtils.toast(e.getMessage());
        }
    }

    public void requestUploadDataPointForBase(String requestBody) {
        RequestManager.sendInBackground((Request)new McsJsonRequest(1, RequestApi.UPLOAD_DATA_POINT.replace("{deviceId}", this.deviceId), requestBody, McsDataChannel$$Lambda$2.lambdaFactory$(), McsDataChannel$$Lambda$3.lambdaFactory$()));
    }

    public String getDeviceId() {
        return this.deviceId;
    }

    public String getDeviceKey() {
        return this.deviceKey;
    }

    public DataChannelEntity getDataChannelEntity() {
        return this.dataChannelEntity;
    }

    public McsSocketListener getMcsSocketListener() {
        return this.mcsSocketListener;
    }

    private static /* synthetic */ void lambda$requestUploadDataPointForBase$2(Exception error) {
        McsLog.e(error, new Object[0]);
    }

    private static /* synthetic */ void lambda$requestUploadDataPointForBase$1(JSONObject response) {
        McsLog.d(response.toString(), new Object[0]);
    }

    private /* synthetic */ void lambda$new$0(JSONObject response) {
        try {
            JSONObject data = response.getJSONObject("updateDatapoint");
            DataPointEntity dp = (DataPointEntity)new Gson().fromJson(data.toString(), DataPointEntity.class);
            this.setDataPointEntity(dp);
        }
        catch (JSONException e) {
            McsLog.e(e.toString(), new Object[0]);
        }
    }

    static /* synthetic */ void access$lambda$0(McsDataChannel mcsDataChannel, JSONObject jSONObject) {
        mcsDataChannel.lambda$new$0(jSONObject);
    }

    static /* synthetic */ void access$lambda$1(JSONObject jSONObject) {
        McsDataChannel.lambda$requestUploadDataPointForBase$1(jSONObject);
    }

    static /* synthetic */ void access$lambda$2(Exception exception) {
        McsDataChannel.lambda$requestUploadDataPointForBase$2(exception);
    }
}

