/*
 * Decompiled with CFR 0.152.
 */
package com.mediatek.mcs.domain;

import com.mediatek.mcs.R;
import com.mediatek.mcs.domain.McsDataChannelType;
import com.mediatek.mcs.domain.McsGeoPoint;
import com.mediatek.mcs.entity.DataChannelEntity;
import com.mediatek.mcs.entity.DataPointEntity;
import com.mediatek.mcs.exception.InvalidDataPointException;
import java.math.RoundingMode;
import java.text.DecimalFormat;
import java.text.NumberFormat;

public class DataPointFormatter {
    public static DataPointEntity.Values formatValues(DataChannelEntity channel, DataPointEntity.Values values) throws InvalidDataPointException {
        if (values == null) {
            throw new InvalidDataPointException(R.string.error_invalid_upload_dp);
        }
        switch (McsDataChannelType.getChannelType(channel)) {
            case 1: 
            case 2: {
                return DataPointFormatter.getFormatValues(values.getValue());
            }
            case 4: 
            case 5: {
                return values;
            }
            case 13: {
                return values;
            }
            case 6: {
                return new DataPointEntity.Values(new McsGeoPoint(values).trim());
            }
            case 12: 
            case 26: {
                return DataPointFormatter.getFormatValues(values.getValue(), values.getPeriod());
            }
            case 7: 
            case 10: 
            case 11: {
                return values;
            }
        }
        throw new InvalidDataPointException(R.string.error_invalid_upload_dp);
    }

    public static DataPointEntity.Values getFormatValues(String value) throws InvalidDataPointException {
        return new DataPointEntity.Values(DataPointFormatter.formatDecimal(value));
    }

    public static DataPointEntity.Values getFormatValues(String value, String period) throws InvalidDataPointException {
        return new DataPointEntity.Values(DataPointFormatter.formatDecimal(value), DataPointFormatter.formatDecimal(period));
    }

    static String formatDecimal(String decimalString) throws InvalidDataPointException {
        try {
            String formattedString = decimalString.replaceFirst("^0+(?!$)", "");
            DecimalFormat formatter = (DecimalFormat)NumberFormat.getInstance();
            formatter.setMinimumIntegerDigits(1);
            formatter.setMaximumFractionDigits(16);
            formatter.setGroupingUsed(false);
            return formatter.format(Double.parseDouble(formattedString));
        }
        catch (Exception e) {
            throw new InvalidDataPointException(R.string.error_invalid_upload_dp, (Throwable)e);
        }
    }

    public static String trimGeoValue(Object value) throws InvalidDataPointException {
        try {
            DecimalFormat df = new DecimalFormat("#.######");
            df.setRoundingMode(RoundingMode.HALF_EVEN);
            value = Double.parseDouble(value.toString());
            return df.format(value);
        }
        catch (NumberFormatException e) {
            throw new InvalidDataPointException(R.string.error_invalid_upload_dp, (Throwable)e);
        }
    }
}

