/*
 * Decompiled with CFR 0.152.
 */
package com.mediatek.mcs.Utils;

import android.app.AlertDialog;
import android.content.Context;
import android.content.DialogInterface;
import android.widget.Toast;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.mediatek.mcs.Mcs;
import com.mediatek.mcs.R;
import com.mediatek.mcs.Utils.UIUtils$$Lambda$1;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;

public class UIUtils {
    public static final String SERVER_DATE_FORMAT = "yyyy-MM-dd'T'HH:mm:ss.SSS'Z'";
    public static final String DISPLAY_DATE_FORMAT = "yyyy-MM-dd HH:mm";

    public static Gson getFormattedGson() {
        return new GsonBuilder().setDateFormat(new SimpleDateFormat(SERVER_DATE_FORMAT, Locale.getDefault()).toPattern()).create();
    }

    public static String getDateString(Date updatedAt) {
        try {
            return new SimpleDateFormat(DISPLAY_DATE_FORMAT, Locale.getDefault()).format(updatedAt);
        }
        catch (Exception e) {
            return "";
        }
    }

    public static String getDateString(Long timeMillis) {
        return UIUtils.getDateString(new Date(timeMillis));
    }

    public static void setTitleAlertDialog(Context context, String title, DialogInterface.OnClickListener positiveListener) {
        new AlertDialog.Builder(context).setIconAttribute(16843605).setTitle((CharSequence)String.format(title, context.getString(R.string.app_name))).setPositiveButton(R.string.dialog_action_affirmative, positiveListener).setNegativeButton(R.string.dialog_action_cancel, UIUtils$$Lambda$1.lambdaFactory$()).create().show();
    }

    public static void toast(int resId) {
        UIUtils.toast(Mcs.getApplicationContext().getString(resId));
    }

    public static void toast(String msg) {
        UIUtils.toast(msg, true, false);
    }

    public static void toast(String msg, Boolean isShort, Boolean isCenter) {
        Toast toast = Toast.makeText((Context)Mcs.getApplicationContext(), (CharSequence)msg, (int)(isShort != false ? 0 : 1));
        if (isCenter.booleanValue()) {
            toast.setGravity(17, 0, 0);
        }
        toast.show();
    }

    private static /* synthetic */ void lambda$setTitleAlertDialog$18(DialogInterface dialog, int dismissiveAction) {
    }

    static /* synthetic */ void access$lambda$0(DialogInterface dialogInterface, int n) {
        UIUtils.lambda$setTitleAlertDialog$18(dialogInterface, n);
    }
}

