package com.mediatek.mcs.entity;

import com.mediatek.mcs.net.RequestApi;
import java.util.List;
import lombok.AccessLevel;
import lombok.Getter;

@Getter public class ProductEntity extends McsEntity {
  private String prodId;
  private String name;
  private String description;
  private String chip;
  private List<DisplayConfigEntity> displayConfigs;
  private String version;
  private String privilege;

  private String createdByNickName;
  private Industry prodIndType;
  private Application prodAppType;
  private Image images;

  @Getter public static class Industry {
    private Integer prodIndTypeId;
    private String name;
  }

  @Getter public static class Application {
    private Integer prodAppTypeId;
    private String name;
  }

  @Getter public static class Image {
    private boolean isMain;
    private String prodImgId;
    @Getter(AccessLevel.NONE) private String url; // relative path, need getImageServerPrefix()
    private String description;

    public String getUrl() {
      return RequestApi.getImageServerPrefix() + url;
    }
  }
}