package com.mediatek.mcs.entity;

import java.util.List;
import lombok.AllArgsConstructor;
import lombok.Getter;

@Getter public class DeviceNotifEntity extends McsEntity {
  private NotifGroup[] deviceNtfCritGrps;

  @Getter public static class NotifGroup {
    private String name;
    private List<Criterion> ntfcrits;
    private List<Method> ntfmths;
    /**
     * required field for DEVICE_NOTIF_GROUP
     */
    private String ntfCritGrpId;
    private Boolean isProdActivated;
    private Boolean isDeviceActivated;
  }

  @Getter public static class Criterion {
    private Float thresholdValue;     // if null, use defaultThresholdValue
    private Float defaultThresholdValue;
    private String operand;
    private String name;
    private Format format;
    private UnitTypeEntity unitType;

    /**
     * required field for DEVICE_NOTIF_GROUP
     */
    private Integer ntfCritId;
    private Integer streamId;
  }

  @Getter public static class Method {
    private String name;
    private String title;
    private String content;
  }

  @Getter public static class Format {
    private String lowerbound;
    private String upperbound;
  }

  @AllArgsConstructor
  public static class Update {
    private Boolean isActivated;
    private List<UpdateCriterion> ntfcrits;
  }

  @AllArgsConstructor
  public static class UpdateCriterion {
    /**
     * required field for DEVICE_NOTIF_GROUP
     */
    private Integer ntfCritId;
    private Integer streamId;
    private Float thresholdValue;
  }
}
