package com.mediatek.mcs.domain;

import com.mediatek.mcs.entity.DataChannelEntity;

public class McsDataChannelType {
  public static final int GPIO = 11;         // EDIT (19, 11), VIEW (21, 11)
  public static final int INT = 1;           // (14, 1), (4, 1)
  public static final int FLOAT = 2;         // (15, 2), (5, 2)
  public static final int HEX = 4;           // (16, 4), (8, 4)
  public static final int CATEGORY = 10;     // (, 10)
  public static final int STRING = 5;   // (17, 5), (6, 5)
  public static final int GPS = 6;           // (18, 6), (7, 6)
  public static final int SLIDER = 13;          //

  public static final int PWM = 12;          // PWM: (20, 12)
  public static final int PWM_SLIDER = 26;   // PWM-slider: (26, 12)
  public static final int PWM_DISPLAY = 22;  // display PWM: (22, 12)
  public static final int SWITCH_EDIT = 7;   // (1, 7)
  public static final int SWITCH_VIEW = 3;   // (2, 3)

  public static int getChannelType(DataChannelEntity channel) {
    int channelTypeId = channel.getChannelType().getDataChnTypeId();

    if (channelTypeId == PWM) {
      return (!channel.isControllable()) ? PWM_DISPLAY
          : (channel.getFormat() == null || channel.getFormat().getLowerbound() == null) ? PWM
              : PWM_SLIDER;
      // only PWM_SLIDER has format: upperbound, lowerbound, PWM & PWM_DISPLAY does not have
    }

    return channelTypeId;
  }
}
