/*
 * Decompiled with CFR 0.152.
 */
package com.mediatek.mcs.pref;

import android.content.Context;
import android.content.SharedPreferences;
import android.preference.PreferenceManager;
import com.google.gson.Gson;
import com.mediatek.mcs.Mcs;
import com.mediatek.mcs.entity.McsUserInfoEntity;
import com.mediatek.mcs.pref.McsPreferences;
import org.json.JSONObject;

public final class McsUserInfo
implements McsPreferences {
    private static final String USER_INFO_NICKNAME = "USER_INFO_NICKNAME";
    private static final String USER_INFO_IMAGE_URL = "USER_INFO_IMAGE_URL";
    private static McsUserInfo INSTANCE = new McsUserInfo();
    private Gson gson = new Gson();
    private SharedPreferences pref = PreferenceManager.getDefaultSharedPreferences((Context)Mcs.getApplicationContext());
    private String userImageURL;
    private String nickname = this.pref.getString("USER_INFO_NICKNAME", "");

    private McsUserInfo() {
        this.userImageURL = this.pref.getString(USER_INFO_IMAGE_URL, "");
    }

    public static McsUserInfo getInstance() {
        return INSTANCE;
    }

    @Override
    public void clearPref() {
        this.nickname = "";
        this.userImageURL = "";
        this.savePref();
    }

    @Override
    public void savePref() {
        SharedPreferences.Editor editor = this.pref.edit();
        editor.putString(USER_INFO_NICKNAME, this.nickname);
        editor.putString(USER_INFO_IMAGE_URL, this.userImageURL);
        editor.commit();
    }

    public void saveToPref(JSONObject response) {
        this.saveUserInfo((McsUserInfoEntity)this.gson.fromJson(response.toString(), McsUserInfoEntity.class));
    }

    private void saveUserInfo(McsUserInfoEntity info) {
        this.setNickname(info.getNickname());
        this.setUserImageURL(info.getUserImageURL());
        this.savePref();
    }

    public String getUserImageURL() {
        return this.userImageURL;
    }

    public void setUserImageURL(String userImageURL) {
        this.userImageURL = userImageURL;
    }

    public String getNickname() {
        return this.nickname;
    }

    public void setNickname(String nickname) {
        this.nickname = nickname;
    }
}

